"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVisualizeEmbeddableFactory = void 0;
var _eui = require("@elastic/eui");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _public3 = require("@kbn/expressions-plugin/public");
var _i18n = require("@kbn/i18n");
var _public4 = require("@kbn/kibana-utils-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _publishes_search_session = require("@kbn/presentation-publishing/interfaces/fetch/publishes_search_session");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _reactHooks = require("@kbn/react-hooks");
var _constants = require("../../common/constants");
var _events = require("./events");
var _services = require("../services");
var _triggers = require("../triggers");
var _create_vis_instance = require("./create_vis_instance");
var _get_expression_renderer_props = require("./get_expression_renderer_props");
var _save_to_library = require("./save_to_library");
var _state = require("./state");
var _initialize_edit_api = require("./initialize_edit_api");
var _saved_objects_utils = require("../utils/saved_objects_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/visualizations/public/embeddable/visualize_embeddable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getVisualizeEmbeddableFactory = ({
  embeddableStart,
  embeddableEnhancedStart
}) => ({
  type: _constants.VISUALIZE_EMBEDDABLE_TYPE,
  buildEmbeddable: async ({
    initialState,
    finalizeApi,
    parentApi,
    uuid
  }) => {
    var _runtimeState$savedOb, _dynamicActionsManage2;
    // Runtime state may contain title loaded from saved object
    // Initialize titleManager with serialized state
    // to avoid tracking runtime state title as serialized state title
    const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState.rawState);

    // Initialize dynamic actions
    const dynamicActionsManager = embeddableEnhancedStart === null || embeddableEnhancedStart === void 0 ? void 0 : embeddableEnhancedStart.initializeEmbeddableDynamicActions(uuid, () => titleManager.api.title$.getValue(), initialState);
    // if it is provided, start the dynamic actions manager
    const maybeStopDynamicActions = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.startDynamicActions();
    const runtimeState = await (0, _state.deserializeState)(initialState);

    // Count renders; mostly used for testing.
    const renderCount$ = new _rxjs.BehaviorSubject(0);
    const hasRendered$ = new _rxjs.BehaviorSubject(false);

    // Track vis data and initialize it into a vis instance
    const serializedVis$ = new _rxjs.BehaviorSubject(runtimeState.serializedVis);
    const initialVisInstance = await (0, _create_vis_instance.createVisInstance)(runtimeState.serializedVis);
    const vis$ = new _rxjs.BehaviorSubject(initialVisInstance);

    // Track UI state
    const onUiStateChange = () => serializedVis$.next(vis$.getValue().serialize());

    // When the serialized vis changes, update the vis instance
    const serializedVisSubscription = serializedVis$.pipe((0, _rxjs.switchMap)(async serializedVis => {
      const currentVis = vis$.getValue();
      if (currentVis) currentVis.uiState.off('change', onUiStateChange);
      const vis = await (0, _create_vis_instance.createVisInstance)(serializedVis);
      vis.uiState.on('change', onUiStateChange);
      vis$.next(vis);
      const {
        params,
        abortController
      } = await getExpressionParams();
      return {
        params,
        abortController
      };
    })).subscribe(({
      params,
      abortController
    }) => {
      if (params) expressionParams$.next(params);
      expressionAbortController$.next(abortController);
    });

    // Track visualizations linked to a saved object in the library
    const savedObjectId$ = new _rxjs.BehaviorSubject((_runtimeState$savedOb = runtimeState.savedObjectId) !== null && _runtimeState$savedOb !== void 0 ? _runtimeState$savedOb : runtimeState.serializedVis.id);
    const linkedToLibrary = Boolean(runtimeState.savedObjectId);

    // Track the vis expression
    const expressionParams$ = new _rxjs.BehaviorSubject({
      expression: ''
    });
    const expressionAbortController$ = new _rxjs.BehaviorSubject(new AbortController());
    let getExpressionParams = async () => ({
      params: expressionParams$.getValue(),
      abortController: expressionAbortController$.getValue()
    });
    const timeRangeManager = (0, _presentationPublishing.initializeTimeRangeManager)(runtimeState);
    const searchSessionId$ = new _rxjs.BehaviorSubject('');
    const executionContext = (0, _presentationPublishing.apiHasExecutionContext)(parentApi) ? parentApi.executionContext : undefined;
    const disableTriggers = (0, _presentationPublishing.apiHasDisableTriggers)(parentApi) ? parentApi.disableTriggers : undefined;
    const inspectorAdapters$ = new _rxjs.BehaviorSubject({});

    // Track data views
    let initialDataViews = [];
    if (initialVisInstance.data.indexPattern) initialDataViews = [initialVisInstance.data.indexPattern];
    if (initialVisInstance.type.getUsedIndexPattern) {
      initialDataViews = await initialVisInstance.type.getUsedIndexPattern(initialVisInstance.params);
    }
    const dataLoading$ = new _rxjs.BehaviorSubject(true);
    const defaultTitle$ = new _rxjs.BehaviorSubject(initialVisInstance.title);
    const serializeVisualizeEmbeddable = (savedObjectId, linkedToLibraryArg) => {
      return (0, _state.serializeState)({
        serializedVis: vis$.getValue().serialize(),
        titles: titleManager.getLatestState(),
        id: savedObjectId,
        linkedToLibrary: linkedToLibraryArg,
        ...(runtimeState.savedObjectProperties ? {
          savedObjectProperties: runtimeState.savedObjectProperties
        } : {}),
        getDynamicActionsState: dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.getLatestState,
        ...timeRangeManager.getLatestState()
      });
    };
    const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
      uuid,
      parentApi,
      serializeState: () => {
        return serializeVisualizeEmbeddable(savedObjectId$.getValue(), linkedToLibrary);
      },
      anyStateChange$: (0, _rxjs.merge)(...(dynamicActionsManager ? [dynamicActionsManager.anyStateChange$] : []), savedObjectId$, serializedVis$, titleManager.anyStateChange$, timeRangeManager.anyStateChange$).pipe((0, _rxjs.map)(() => undefined)),
      getComparators: () => {
        var _dynamicActionsManage;
        return {
          ...((_dynamicActionsManage = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.comparators) !== null && _dynamicActionsManage !== void 0 ? _dynamicActionsManage : {
            enhancements: 'skip'
          }),
          ..._presentationPublishing.titleComparators,
          ..._presentationPublishing.timeRangeComparators,
          savedObjectId: 'skip',
          uiState: linkedToLibrary ? 'deepEquality' : 'skip',
          savedVis: linkedToLibrary ? 'skip' : (a, b) => {
            function deepOmitBy(value) {
              if (value && !Array.isArray(value) && typeof value === 'object') {
                const keys = Object.keys(value);
                if (!keys.length) return;
                const cleanedValue = {};
                keys.forEach(key => {
                  const cleanedSubvalue = deepOmitBy(value[key]);
                  if (cleanedSubvalue) {
                    cleanedValue[key] = cleanedSubvalue;
                  }
                });
                return cleanedValue;
              }
              return value;
            }
            return (0, _lodash.isEqual)(deepOmitBy(a), deepOmitBy(b));
          }
        };
      },
      onReset: async lastSaved => {
        var _lastSaved$rawState;
        dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.reinitializeState((_lastSaved$rawState = lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState) !== null && _lastSaved$rawState !== void 0 ? _lastSaved$rawState : {});
        timeRangeManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
        titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
        if (!lastSaved) return;
        const lastSavedRuntimeState = await (0, _state.deserializeState)(lastSaved);
        serializedVis$.next(lastSavedRuntimeState.serializedVis);
      }
    });
    const api = finalizeApi({
      ...timeRangeManager.api,
      ...titleManager.api,
      ...((_dynamicActionsManage2 = dynamicActionsManager === null || dynamicActionsManager === void 0 ? void 0 : dynamicActionsManager.api) !== null && _dynamicActionsManage2 !== void 0 ? _dynamicActionsManage2 : {}),
      ...unsavedChangesApi,
      defaultTitle$,
      dataLoading$,
      dataViews$: new _rxjs.BehaviorSubject(initialDataViews),
      rendered$: hasRendered$,
      supportedTriggers: () => [_triggers.ACTION_CONVERT_TO_LENS, _public.APPLY_FILTER_TRIGGER, _public2.SELECT_RANGE_TRIGGER],
      serializeState: () => {
        // In the visualize editor, linkedToLibrary should always be false to force the full state to be serialized,
        // instead of just passing a reference to the linked saved object. Other contexts like dashboards should
        // serialize the state with just the savedObjectId so that the current revision of the vis is always used
        const forcedLinkedToLibrary = (0, _presentationPublishing.apiIsOfType)(parentApi, _constants.VISUALIZE_APP_NAME) ? false : linkedToLibrary;
        return serializeVisualizeEmbeddable(savedObjectId$.getValue(), forcedLinkedToLibrary);
      },
      getVis: () => vis$.getValue(),
      getInspectorAdapters: () => inspectorAdapters$.getValue(),
      ...(0, _initialize_edit_api.initializeEditApi)({
        customTimeRange$: timeRangeManager.api.timeRange$,
        description$: titleManager.api.description$,
        parentApi,
        savedObjectId$,
        searchSessionId$,
        title$: titleManager.api.title$,
        vis$,
        uuid
      }),
      updateVis: async visUpdates => {
        const currentSerializedVis = vis$.getValue().serialize();
        serializedVis$.next({
          ...currentSerializedVis,
          ...visUpdates,
          params: {
            ...currentSerializedVis.params,
            ...visUpdates.params
          },
          data: {
            ...currentSerializedVis.data,
            ...visUpdates.data
          }
        });
        if (visUpdates.title) {
          titleManager.api.setTitle(visUpdates.title);
        }
      },
      openInspector: () => {
        var _titleManager$api$tit;
        const adapters = inspectorAdapters$.getValue();
        if (!adapters) return;
        const inspector = (0, _services.getInspector)();
        if (!inspector.isAvailable(adapters)) return;
        return (0, _services.getInspector)().open(adapters, {
          title: ((_titleManager$api$tit = titleManager.api.title$) === null || _titleManager$api$tit === void 0 ? void 0 : _titleManager$api$tit.getValue()) || _i18n.i18n.translate('visualizations.embeddable.inspectorTitle', {
            defaultMessage: 'Inspector'
          })
        });
      },
      // Library transforms
      saveToLibrary: newTitle => {
        titleManager.api.setTitle(newTitle);
        return (0, _save_to_library.saveToLibrary)({
          description: titleManager.api.description$.value,
          serializedVis: vis$.getValue().serialize(),
          title: newTitle,
          uiState: vis$.getValue().uiState
        });
      },
      canLinkToLibrary: () => Promise.resolve(!linkedToLibrary),
      canUnlinkFromLibrary: () => Promise.resolve(linkedToLibrary),
      checkForDuplicateTitle: async (newTitle, isTitleDuplicateConfirmed, onTitleDuplicate) => {
        await (0, _saved_objects_utils.checkForDuplicateTitle)({
          title: newTitle,
          lastSavedTitle: ''
        }, false, isTitleDuplicateConfirmed, onTitleDuplicate);
      },
      getSerializedStateByValue: () => serializeVisualizeEmbeddable(undefined, false),
      getSerializedStateByReference: libraryId => serializeVisualizeEmbeddable(libraryId, true)
    });
    const fetchSubscription = (0, _presentationPublishing.fetch$)(api).pipe((0, _rxjs.switchMap)(async data => {
      var _ref;
      const unifiedSearch = (0, _presentationPublishing.apiPublishesUnifiedSearch)(parentApi) ? {
        query: data.query,
        filters: data.filters
      } : {};
      const searchSessionId = (0, _publishes_search_session.apiPublishesSearchSession)(parentApi) ? data.searchSessionId : '';
      searchSessionId$.next(searchSessionId);
      const settings = (0, _presentationContainers.apiPublishesSettings)(parentApi) ? {
        syncColors: parentApi.settings.syncColors$.getValue(),
        syncCursor: parentApi.settings.syncCursor$.getValue(),
        syncTooltips: parentApi.settings.syncTooltips$.getValue()
      } : {};
      dataLoading$.next(true);
      const timeslice = (0, _presentationPublishing.apiPublishesTimeslice)(parentApi) ? parentApi.timeslice$.getValue() : undefined;
      const customTimeRange = timeRangeManager.api.timeRange$.getValue();
      const parentTimeRange = (0, _presentationPublishing.apiPublishesTimeRange)(parentApi) ? data.timeRange : undefined;
      const timesliceTimeRange = timeslice ? {
        from: new Date(timeslice[0]).toISOString(),
        to: new Date(timeslice[1]).toISOString(),
        mode: 'absolute'
      } : undefined;

      // Precedence should be:
      //  custom time range from state >
      //  timeslice time range >
      //  parent API time range from e.g. unified search
      const timeRangeToRender = (_ref = customTimeRange !== null && customTimeRange !== void 0 ? customTimeRange : timesliceTimeRange) !== null && _ref !== void 0 ? _ref : parentTimeRange;
      getExpressionParams = async () => {
        return await (0, _get_expression_renderer_props.getExpressionRendererProps)({
          unifiedSearch,
          vis: vis$.getValue(),
          settings,
          disableTriggers,
          searchSessionId,
          parentExecutionContext: executionContext,
          abortController: expressionAbortController$.getValue(),
          timeRange: timeRangeToRender,
          onRender: async renderCount => {
            var _executionContext$typ;
            if (renderCount === renderCount$.getValue()) return;
            renderCount$.next(renderCount);
            const visInstance = vis$.getValue();
            const visTypeName = visInstance.type.name;
            let telemetryVisTypeName = visTypeName;
            if (visTypeName === 'metrics') {
              telemetryVisTypeName = 'legacy_metric';
            }
            if (visTypeName === 'pie' && visInstance.params.isDonut) {
              telemetryVisTypeName = 'donut';
            }
            if (visTypeName === 'area' && visInstance.params.seriesParams.some(seriesParams => seriesParams.mode === 'stacked')) {
              telemetryVisTypeName = 'area_stacked';
            }
            (0, _services.getUsageCollection)().reportUiCounter((_executionContext$typ = executionContext === null || executionContext === void 0 ? void 0 : executionContext.type) !== null && _executionContext$typ !== void 0 ? _executionContext$typ : '', 'count', `render_agg_based_${telemetryVisTypeName}`);
            if (hasRendered$.getValue() === true) return;
            hasRendered$.next(true);
          },
          onEvent: async event => {
            // Visualize doesn't respond to sizing events, so ignore.
            if ((0, _chartExpressionsCommon.isChartSizeEvent)(event)) {
              return;
            }
            const currentVis = vis$.getValue();
            if (!disableTriggers) {
              const triggerId = (0, _lodash.get)(_events.VIS_EVENT_TO_TRIGGER, event.name, _events.VIS_EVENT_TO_TRIGGER.filter);
              let context;
              if (triggerId === _events.VIS_EVENT_TO_TRIGGER.applyFilter) {
                var _currentVis$data$inde;
                context = {
                  embeddable: api,
                  timeFieldName: (_currentVis$data$inde = currentVis.data.indexPattern) === null || _currentVis$data$inde === void 0 ? void 0 : _currentVis$data$inde.timeFieldName,
                  ...event.data
                };
              } else {
                var _currentVis$data$inde2;
                context = {
                  embeddable: api,
                  data: {
                    timeFieldName: (_currentVis$data$inde2 = currentVis.data.indexPattern) === null || _currentVis$data$inde2 === void 0 ? void 0 : _currentVis$data$inde2.timeFieldName,
                    ...event.data
                  }
                };
              }
              await (0, _services.getUiActions)().getTrigger(triggerId).exec(context);
            }
          },
          onData: (_, inspectorAdapters) => {
            inspectorAdapters$.next(typeof inspectorAdapters === 'function' ? inspectorAdapters() : inspectorAdapters);
            dataLoading$.next(false);
          }
        });
      };
      return await getExpressionParams();
    })).subscribe(({
      params,
      abortController
    }) => {
      if (params) expressionParams$.next(params);
      expressionAbortController$.next(abortController);
    });
    return {
      api,
      Component: () => {
        var _api$description$$get, _api$description$;
        const expressionParams = (0, _presentationPublishing.useStateFromPublishingSubject)(expressionParams$);
        const renderCount = (0, _presentationPublishing.useStateFromPublishingSubject)(renderCount$);
        const hasRendered = (0, _presentationPublishing.useStateFromPublishingSubject)(hasRendered$);
        const [hideTitle, title, defaultTitle] = (0, _presentationPublishing.useBatchedPublishingSubjects)(api.hideTitle$, api.title$, api.defaultTitle$);
        const domNode = (0, _react.useRef)(null);
        const {
          error,
          isLoading
        } = (0, _public3.useExpressionRenderer)(domNode, expressionParams);
        const errorTextStyle = (0, _reactHooks.useErrorTextStyle)();
        const dataTitle = (0, _react.useMemo)(() => {
          var _ref2;
          if (hideTitle) return '';
          return (_ref2 = title !== null && title !== void 0 ? title : defaultTitle) !== null && _ref2 !== void 0 ? _ref2 : '';
        }, [hideTitle, title, defaultTitle]);
        (0, _react.useEffect)(() => {
          return () => {
            fetchSubscription.unsubscribe();
            serializedVisSubscription.unsubscribe();
            maybeStopDynamicActions === null || maybeStopDynamicActions === void 0 ? void 0 : maybeStopDynamicActions.stopDynamicActions();
          };
        }, []);
        (0, _react.useEffect)(() => {
          if (hasRendered && domNode.current) {
            (0, _public4.dispatchRenderComplete)(domNode.current);
          }
        }, [hasRendered]);
        return /*#__PURE__*/_react.default.createElement("div", {
          css: {
            width: '100%',
            height: '100%'
          },
          ref: domNode,
          "data-test-subj": "visualizationLoader",
          "data-rendering-count": renderCount /* Used for functional tests */,
          "data-render-complete": hasRendered,
          "data-title": dataTitle,
          "data-description": (_api$description$$get = (_api$description$ = api.description$) === null || _api$description$ === void 0 ? void 0 : _api$description$.getValue()) !== null && _api$description$$get !== void 0 ? _api$description$$get : '',
          "data-shared-item": true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 484,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          css: {
            height: '100%'
          },
          justifyContent: "center",
          alignItems: "center",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 495,
            columnNumber: 13
          }
        }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
          size: "l",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 496,
            columnNumber: 29
          }
        }), !isLoading && error && /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
          iconType: "error",
          color: "danger",
          "data-test-subj": "embeddableError",
          title: /*#__PURE__*/_react.default.createElement("h2", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 503,
              columnNumber: 21
            }
          }, _i18n.i18n.translate('visualizations.embeddable.errorTitle', {
            defaultMessage: 'Unable to load visualization '
          })),
          body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            css: errorTextStyle,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 510,
              columnNumber: 21
            }
          }, error.name, ": ", error.message),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 498,
            columnNumber: 17
          }
        })));
      }
    };
  }
});
exports.getVisualizeEmbeddableFactory = getVisualizeEmbeddableFactory;