"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationMissedSavedObjectError = void 0;
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _common = require("@kbn/data-plugin/common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/visualizations/public/components/visualization_missed_saved_object_error.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const VisualizationMissedSavedObjectError = ({
  savedObjectMeta,
  application,
  message,
  renderMode
}) => {
  const {
    management: isManagementEnabled
  } = application.capabilities.navLinks;
  const isIndexPatternManagementEnabled = application.capabilities.management.kibana.indexPatterns;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    iconColor: "danger",
    "data-test-subj": "visualization-missed-data-view-error",
    actions: savedObjectMeta.savedObjectType === _common.DATA_VIEW_SAVED_OBJECT_TYPE && renderMode === 'edit' && isManagementEnabled && isIndexPatternManagementEnabled ? /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      navigateToUrl: application.navigateToUrl,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("a", {
      href: application.getUrlForApp('management', {
        path: '/kibana/indexPatterns/create'
      }),
      "data-test-subj": "configuration-failure-reconfigure-indexpatterns",
      css: {
        width: '100%'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('visualizations.missedDataView.dataViewReconfigure', {
      defaultMessage: `Recreate it in the data view management page`
    }))) : null,
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 13
      }
    }, message),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  });
};
exports.VisualizationMissedSavedObjectError = VisualizationMissedSavedObjectError;