"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.injectVisReferences = injectVisReferences;
var _common = require("@kbn/data-plugin/common");
var _controls_references = require("./controls_references");
var _timeseries_references = require("./timeseries_references");
var _extract_vis_references = require("./extract_vis_references");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function injectVisReferences(savedVis, references) {
  const {
    searchSource,
    savedSearchRefName,
    ...restOfData
  } = savedVis.data;
  let injectedSearchSource = searchSource;
  if (searchSource) {
    try {
      // due to a bug in 8.0, some visualizations were saved with an injected state - re-extract in that case and inject the upstream references because they might have changed
      if (searchSource.index && !searchSource.indexRefName) {
        const extractResults = (0, _common.extractReferences)(searchSource);
        injectedSearchSource = (0, _common.injectReferences)(extractResults[0], [...references, ...extractResults[1]]);
      } else {
        injectedSearchSource = (0, _common.injectReferences)(searchSource, references);
      }
    } catch (e) {
      // Allow missing index pattern error to surface in vis
    }
  }
  if (savedVis.params) {
    // side effect mutates savedVis.params
    (0, _controls_references.injectControlsReferences)(savedVis.type, savedVis.params, references);
    // side effect mutates savedVis.params
    (0, _timeseries_references.injectTimeSeriesReferences)(savedVis.type, savedVis.params, references);
  }
  const savedSearchRef = references.find(reference => reference.name === _extract_vis_references.DISCOVER_SESSION_REF_NAME);
  return {
    ...savedVis,
    data: {
      ...restOfData,
      searchSource: injectedSearchSource,
      ...(savedSearchRef ? {
        savedSearchId: savedSearchRef.id
      } : {})
    }
  };
}