"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DISCOVER_SESSION_REF_NAME = void 0;
exports.extractVisReferences = extractVisReferences;
var _common = require("@kbn/data-plugin/common");
var _controls_references = require("./controls_references");
var _timeseries_references = require("./timeseries_references");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const DISCOVER_SESSION_REF_NAME = exports.DISCOVER_SESSION_REF_NAME = 'search_0';
function extractVisReferences(savedVis) {
  const {
    searchSource,
    savedSearchId,
    ...restOfData
  } = savedVis.data;
  const references = [];
  let extractedSearchSource = searchSource;
  if (extractedSearchSource) {
    const results = (0, _common.extractReferences)(extractedSearchSource);
    extractedSearchSource = results[0];
    references.push(...results[1]);
  }

  // Extract discover session
  if (savedSearchId) {
    references.push({
      name: DISCOVER_SESSION_REF_NAME,
      type: 'search',
      id: String(savedSearchId)
    });
  }

  // Extract index patterns from controls
  if (savedVis.params) {
    // side effect mutates savedVis.params and references
    (0, _controls_references.extractControlsReferences)(savedVis.type, savedVis.params, references);
    // side effect mutates savedVis.params and references
    (0, _timeseries_references.extractTimeSeriesReferences)(savedVis.type, savedVis.params, references);
  }
  return {
    savedVis: {
      ...savedVis,
      data: {
        ...restOfData,
        searchSource: extractedSearchSource,
        ...(savedSearchId ? {
          savedSearchRefName: DISCOVER_SESSION_REF_NAME
        } : {})
      }
    },
    references
  };
}