"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIS_SAVED_OBJECT_REF_NAME = void 0;
exports.getTransformIn = getTransformIn;
var _constants = require("../../constants");
var _extract_vis_references = require("../../references/extract_vis_references");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const VIS_SAVED_OBJECT_REF_NAME = exports.VIS_SAVED_OBJECT_REF_NAME = 'savedObjectRef';
function getTransformIn(transformEnhancementsIn) {
  function transformIn(state) {
    const {
      enhancementsState,
      enhancementsReferences
    } = state.enhancements ? transformEnhancementsIn(state.enhancements) : {
      enhancementsState: undefined,
      enhancementsReferences: []
    };

    // by ref
    if (state.savedObjectId) {
      const {
        savedObjectId,
        ...rest
      } = state;
      return {
        state: {
          ...rest,
          ...(enhancementsState ? {
            enhancements: enhancementsState
          } : {})
        },
        references: [{
          name: VIS_SAVED_OBJECT_REF_NAME,
          type: _constants.VISUALIZE_SAVED_OBJECT_TYPE,
          id: savedObjectId
        }, ...enhancementsReferences]
      };
    }

    // by value
    if (state.savedVis) {
      const {
        references,
        savedVis
      } = (0, _extract_vis_references.extractVisReferences)(state.savedVis);
      return {
        state: {
          ...state,
          ...(enhancementsState ? {
            enhancements: enhancementsState
          } : {}),
          savedVis
        },
        references: [...references, ...enhancementsReferences]
      };
    }
    return {
      state: {
        ...state,
        ...(enhancementsState ? {
          enhancements: enhancementsState
        } : {})
      },
      references: enhancementsReferences
    };
  }
  return transformIn;
}