"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThresholdPanel = ThresholdPanel;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _collections = require("../../../collections");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/xy/public/editor/components/options/point_series/threshold_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const thresholdLineStyles = (0, _collections.getThresholdLineStyles)();
function ThresholdPanel({
  stateParams,
  setValue,
  setMultipleValidity
}) {
  const setThresholdLine = (0, _react.useCallback)((paramName, value) => setValue('thresholdLine', {
    ...stateParams.thresholdLine,
    [paramName]: value
  }), [stateParams.thresholdLine, setValue]);
  const setThresholdLineColor = (0, _react.useCallback)(value => setThresholdLine('color', value), [setThresholdLine]);
  const setThresholdLineValidity = (0, _react.useCallback)((paramName, isValid) => setMultipleValidity(`thresholdLine__${paramName}`, isValid), [setMultipleValidity]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeXy.editors.pointSeries.thresholdLineSettingsTitle",
    defaultMessage: "Threshold line",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeXy.editors.pointSeries.thresholdLine.showLabel', {
      defaultMessage: 'Show threshold line'
    }),
    paramName: "show",
    value: stateParams.thresholdLine.show,
    setValue: setThresholdLine,
    "data-test-subj": "xyShowThresholdLine",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), stateParams.thresholdLine.show && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.RequiredNumberInputOption, {
    label: _i18n.i18n.translate('visTypeXy.editors.pointSeries.thresholdLine.valueLabel', {
      defaultMessage: 'Threshold value'
    }),
    paramName: "value",
    value: stateParams.thresholdLine.value,
    setValue: setThresholdLine,
    setValidity: setThresholdLineValidity,
    "data-test-subj": "thresholdValueInputOption",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_public.RequiredNumberInputOption, {
    label: _i18n.i18n.translate('visTypeXy.editors.pointSeries.thresholdLine.widthLabel', {
      defaultMessage: 'Line width'
    }),
    paramName: "width",
    min: 1,
    step: 1,
    value: stateParams.thresholdLine.width,
    setValue: setThresholdLine,
    setValidity: setThresholdLineValidity,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    label: _i18n.i18n.translate('visTypeXy.editors.pointSeries.thresholdLine.styleLabel', {
      defaultMessage: 'Line style'
    }),
    options: thresholdLineStyles,
    paramName: "style",
    value: stateParams.thresholdLine.style,
    setValue: setThresholdLine,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('visTypeXy.editors.pointSeries.thresholdLine.colorLabel', {
      defaultMessage: 'Line color'
    }),
    fullWidth: true,
    display: "rowCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
    compressed: true,
    color: stateParams.thresholdLine.color,
    fullWidth: true,
    onChange: setThresholdLineColor,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  }))));
}