"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YExtents = YExtents;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _types = require("../../../../types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/xy/public/editor/components/options/metrics_axes/y_extents.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const rangeError = _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.minErrorMessage', {
  defaultMessage: 'Min should be less than Max.'
});
const minError = _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.minNeededScaleText', {
  defaultMessage: 'Min must exceed 0 when a log scale is selected.'
});
function areExtentsValid(min = null, max = null) {
  if (min === null || max === null) {
    return true;
  }
  return max > min;
}
function isNullOrUndefined(value) {
  return value === null || value === undefined;
}
function YExtents({
  scale,
  setScale,
  setMultipleValidity
}) {
  const {
    min,
    max,
    type
  } = scale;
  const errors = [];
  if (!areExtentsValid(min, max)) {
    errors.push(rangeError);
  }
  if (type === _types.ScaleType.Log && (isNullOrUndefined(min) || min <= 0)) {
    errors.push(minError);
  }
  const isValid = !errors.length;
  const setExtents = (0, _react.useCallback)((paramName, value) => {
    setScale(paramName, value === '' ? null : value);
  }, [setScale]);
  (0, _react.useEffect)(() => {
    setMultipleValidity('yExtents', isValid);
    return () => setMultipleValidity('yExtents', true);
  }, [isValid, setMultipleValidity]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: errors,
    isInvalid: !!errors.length,
    fullWidth: true,
    display: "rowCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_public.NumberInputOption, {
    "data-test-subj": "yAxisYExtentsMin",
    isInvalid: !!errors.length,
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.minLabel', {
      defaultMessage: 'Min'
    }),
    step: 0.1,
    paramName: "min",
    value: isNullOrUndefined(min) ? '' : min,
    setValue: setExtents,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_public.NumberInputOption, {
    "data-test-subj": "yAxisYExtentsMax",
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.maxLabel', {
      defaultMessage: 'Max'
    }),
    step: 0.1,
    paramName: "max",
    value: isNullOrUndefined(max) ? '' : max,
    setValue: setExtents,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  })))));
}