"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValueAxesPanel = ValueAxesPanel;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _value_axis_options = require("./value_axis_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/xy/public/editor/components/options/metrics_axes/value_axes_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ValueAxesPanel(props) {
  const styles = (0, _use_memo_css.useMemoCss)(_public.visEditorSidebarStyles);
  const {
    addValueAxis,
    removeValueAxis,
    seriesParams,
    valueAxes
  } = props;
  const getSeries = (0, _react.useCallback)(axis => {
    const isFirst = valueAxes[0].id === axis.id;
    const series = seriesParams.filter(serie => serie.valueAxis === axis.id || isFirst && !serie.valueAxis);
    return series.map(serie => serie.data.label).join(', ');
  }, [seriesParams, valueAxes]);
  const removeButtonTooltip = (0, _react.useMemo)(() => _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.removeButtonTooltip', {
    defaultMessage: 'Remove Y-axis'
  }), []);
  const renderRemoveButton = (0, _react.useCallback)(axis => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: removeButtonTooltip,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    iconType: "cross",
    onClick: () => removeValueAxis(axis),
    "aria-label": removeButtonTooltip,
    "data-test-subj": "removeValueAxisBtn",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  })), [removeValueAxis, removeButtonTooltip]);
  const addButtonTooltip = (0, _react.useMemo)(() => _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.addButtonTooltip', {
    defaultMessage: 'Add Y-axis'
  }), []);
  const getButtonContent = (0, _react.useCallback)(axis => {
    const description = getSeries(axis);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, axis.name, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: description,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, description)));
  }, [getSeries]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    justifyContent: "spaceBetween",
    alignItems: "baseline",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeXy.controls.pointSeries.valueAxes.yAxisTitle",
    defaultMessage: "Y-axes",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: addButtonTooltip,
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "plusInCircleFilled",
    onClick: addValueAxis,
    "aria-label": addButtonTooltip,
    "data-test-subj": "visualizeAddYAxisButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }), valueAxes.map((axis, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `yAxisAccordion${axis.id}`,
    key: axis.id,
    "data-test-subj": `toggleYAxisOptions-${axis.id}`,
    className: "visEditorSidebar__section visEditorSidebar__collapsible",
    initialIsOpen: false,
    buttonContent: getButtonContent(axis),
    buttonClassName: "eui-textTruncate",
    buttonContentClassName: "visEditorSidebar__aggGroupAccordionButtonContent eui-textTruncate",
    "aria-label": _i18n.i18n.translate('visTypeXy.controls.pointSeries.valueAxes.toggleOptionsAriaLabel', {
      defaultMessage: 'Toggle {axisName} options',
      values: {
        axisName: axis.name
      }
    }),
    extraAction: valueAxes.length === 1 ? undefined : renderRemoveButton(axis),
    css: [styles.section, styles.collapsible, styles.aggGroupAccordionButtonContent],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_value_axis_options.ValueAxisOptions, {
    axis: axis,
    index: index,
    valueAxis: valueAxes[index],
    onValueAxisPositionChanged: props.onValueAxisPositionChanged,
    setParamByIndex: props.setParamByIndex,
    setMultipleValidity: props.setMultipleValidity,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 13
    }
  })))));
}