"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = MetricsAxisOptions;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _public = require("@kbn/data-plugin/public");
var _series_panel = require("./series_panel");
var _category_axis_panel = require("./category_axis_panel");
var _value_axes_panel = require("./value_axes_panel");
var _utils = require("./utils");
var _get_series_params = require("../../../../utils/get_series_params");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/xy/public/editor/components/options/metrics_axes/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const VALUE_AXIS_PREFIX = 'ValueAxis-';
function MetricsAxisOptions(props) {
  const {
    stateParams,
    setValue,
    aggs,
    vis,
    isTabSelected
  } = props;
  const setParamByIndex = (0, _react.useCallback)((axesName, index, paramName, value) => {
    const items = stateParams[axesName];
    const array = [...items];
    array[index] = {
      ...array[index],
      [paramName]: value
    };
    setValue(axesName, array);
  }, [stateParams, setValue]);
  const setCategoryAxis = (0, _react.useCallback)(value => {
    const categoryAxes = [...stateParams.categoryAxes];
    categoryAxes[0] = value;
    setValue('categoryAxes', categoryAxes);
  }, [setValue, stateParams.categoryAxes]);

  // stores previous aggs' custom labels
  const [lastCustomLabels, setLastCustomLabels] = (0, _react.useState)({});
  // stores previous aggs' field and type
  const [lastSeriesAgg, setLastSeriesAgg] = (0, _react.useState)({});
  const updateAxisTitle = (0, _react.useCallback)(seriesParams => {
    const series = seriesParams || stateParams.seriesParams;
    let isAxesChanged = false;
    let lastValuesChanged = false;
    const lastLabels = {
      ...lastCustomLabels
    };
    const lastMatchingSeriesAgg = {
      ...lastSeriesAgg
    };
    const axes = stateParams.valueAxes.map((axis, axisNumber) => {
      let newCustomLabel = '';
      let updatedAxis;
      const matchingSeries = [];
      series.forEach((serie, seriesIndex) => {
        if (axisNumber === 0 && !serie.valueAxis || serie.valueAxis === axis.id) {
          const aggByIndex = aggs === null || aggs === void 0 ? void 0 : aggs.bySchemaName('metric')[seriesIndex];
          matchingSeries.push(aggByIndex);
        }
      });
      if (matchingSeries.length === 1) {
        var _matchingSeries$;
        // if several series matches to the axis, axis title is set according to the first serie.
        newCustomLabel = (_matchingSeries$ = matchingSeries[0]) === null || _matchingSeries$ === void 0 ? void 0 : _matchingSeries$.makeLabel();
      }
      if (lastCustomLabels[axis.id] !== newCustomLabel && newCustomLabel !== '') {
        const lastSeriesAggType = (0, _lodash.get)(lastSeriesAgg, [matchingSeries[0].id, `type`]); // using array path vs. string because type inference was broken
        const lastSeriesAggField = (0, _lodash.get)(lastSeriesAgg, [matchingSeries[0].id, `field`]);
        const matchingSeriesAggType = (0, _lodash.get)(matchingSeries, '[0]type.name', '');
        const matchingSeriesAggField = (0, _lodash.get)(matchingSeries, '[0]params.field.name', '');
        const aggTypeIsChanged = lastSeriesAggType !== matchingSeriesAggType;
        const aggFieldIsChanged = lastSeriesAggField !== matchingSeriesAggField;
        lastMatchingSeriesAgg[matchingSeries[0].id] = {
          type: matchingSeriesAggType,
          field: matchingSeriesAggField
        };
        lastLabels[axis.id] = newCustomLabel;
        lastValuesChanged = true;
        if (Object.keys(lastCustomLabels).length !== 0 && (aggTypeIsChanged || aggFieldIsChanged || axis.title.text === '' || lastCustomLabels[axis.id] === axis.title.text) && newCustomLabel !== axis.title.text) {
          // Override axis title with new custom label
          updatedAxis = {
            ...axis,
            title: {
              ...axis.title,
              text: newCustomLabel
            }
          };
          isAxesChanged = true;
        }
      }
      return updatedAxis || axis;
    });
    if (isAxesChanged) {
      setValue('valueAxes', axes);
    }
    if (lastValuesChanged) {
      setLastSeriesAgg(lastMatchingSeriesAgg);
      setLastCustomLabels(lastLabels);
    }
  }, [aggs, lastCustomLabels, lastSeriesAgg, setValue, stateParams.seriesParams, stateParams.valueAxes]);
  const onValueAxisPositionChanged = (0, _react.useCallback)((index, axisPosition) => {
    const isHorizontalAxis = (0, _utils.isAxisHorizontal)(axisPosition);
    const valueAxes = [...stateParams.valueAxes];
    const name = (0, _utils.getUpdatedAxisName)(axisPosition, valueAxes);
    const [categoryAxes] = stateParams.categoryAxes;
    if ((0, _utils.isAxisHorizontal)(categoryAxes.position) === isHorizontalAxis) {
      const updatedCategoryAxes = {
        ...categoryAxes,
        position: (0, _utils.mapPosition)(categoryAxes.position)
      };
      setValue('categoryAxes', [updatedCategoryAxes]);
      const oldPosition = valueAxes[index].position;
      const newValueAxes = valueAxes.map(({
        position,
        ...axis
      }, i) => ({
        ...axis,
        position: i === index ? axisPosition : (0, _utils.mapPositionOpposingOpposite)(position, oldPosition, axisPosition)
      }));
      setValue('valueAxes', newValueAxes);
    } else {
      valueAxes[index] = {
        ...valueAxes[index],
        name,
        position: axisPosition
      };
      setValue('valueAxes', valueAxes);
    }
  }, [stateParams.valueAxes, stateParams.categoryAxes, setValue]);
  const onCategoryAxisPositionChanged = (0, _react.useCallback)(axisPosition => {
    const isHorizontalAxis = (0, _utils.isAxisHorizontal)(axisPosition);
    if (stateParams.valueAxes.some(({
      position
    }) => (0, _utils.isAxisHorizontal)(position) === isHorizontalAxis)) {
      const newValueAxes = stateParams.valueAxes.map(({
        position,
        ...axis
      }) => ({
        ...axis,
        position: (0, _utils.mapPosition)(position)
      }));
      setValue('valueAxes', newValueAxes);
    }
  }, [setValue, stateParams.valueAxes]);
  const addValueAxis = (0, _react.useCallback)(() => {
    const nextAxisIdNumber = stateParams.valueAxes.reduce((0, _utils.countNextAxisNumber)(VALUE_AXIS_PREFIX), 1);
    const newAxis = (0, _lodash.cloneDeep)(stateParams.valueAxes[0]);
    newAxis.id = VALUE_AXIS_PREFIX + nextAxisIdNumber;
    newAxis.position = (0, _utils.mapPositionOpposite)(newAxis.position);
    newAxis.name = (0, _utils.getUpdatedAxisName)(newAxis.position, stateParams.valueAxes);
    setValue('valueAxes', [...stateParams.valueAxes, newAxis]);
    return newAxis;
  }, [stateParams.valueAxes, setValue]);
  const removeValueAxis = (0, _react.useCallback)(axis => {
    const newValueAxes = stateParams.valueAxes.filter(valAxis => valAxis.id !== axis.id);
    setValue('valueAxes', newValueAxes);
    let isSeriesUpdated = false;
    const series = stateParams.seriesParams.map(ser => {
      if (axis.id === ser.valueAxis) {
        isSeriesUpdated = true;
        return {
          ...ser,
          valueAxis: newValueAxes[0].id
        };
      }
      return ser;
    });
    if (isSeriesUpdated) {
      // if seriesParams have valueAxis equals to removed one, then we reset it to the first valueAxis
      setValue('seriesParams', series);
    }
    if (stateParams.grid.valueAxis === axis.id) {
      // reset Y-axis grid lines setting
      setValue('grid', {
        ...stateParams.grid,
        valueAxis: undefined
      });
    }
  }, [stateParams.seriesParams, stateParams.valueAxes, setValue, stateParams.grid]);
  const changeValueAxis = (0, _react.useCallback)((index, paramName, selectedValueAxis) => {
    let newValueAxis = selectedValueAxis;
    if (selectedValueAxis === 'new') {
      const axis = addValueAxis();
      newValueAxis = axis.id;
    }
    setParamByIndex('seriesParams', index, paramName, newValueAxis);
    updateAxisTitle();
  }, [addValueAxis, setParamByIndex, updateAxisTitle]);
  const schemaName = vis.type.schemas.metrics[0].name;
  const firstValueAxesId = stateParams.valueAxes[0].id;
  (0, _react.useEffect)(() => {
    const updatedSeries = (0, _get_series_params.getSeriesParams)(aggs, stateParams.seriesParams, schemaName, firstValueAxesId);
    if (updatedSeries) setValue('seriesParams', updatedSeries);
    updateAxisTitle(updatedSeries);
  }, [firstValueAxesId, setValue, stateParams.seriesParams, updateAxisTitle, aggs, schemaName]);
  const isTimeViz = aggs === null || aggs === void 0 ? void 0 : aggs.aggs.some(agg => {
    var _agg$type;
    return agg.schema === 'segment' && agg.enabled && ((_agg$type = agg.type) === null || _agg$type === void 0 ? void 0 : _agg$type.name) === _public.BUCKET_TYPES.DATE_HISTOGRAM;
  });
  const xAxisIsHorizontal = stateParams.categoryAxes[0].position === _charts.Position.Bottom || stateParams.categoryAxes[0].position === _charts.Position.Top;
  const linearOrStackedBars = stateParams.seriesParams.every(({
    mode,
    type
  }) => type !== 'histogram' || type === 'histogram' && mode === 'stacked');
  const disableAxisControls = xAxisIsHorizontal && isTimeViz && linearOrStackedBars;
  return isTabSelected ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_series_panel.SeriesPanel, {
    changeValueAxis: changeValueAxis,
    setParamByIndex: setParamByIndex,
    seriesParams: stateParams.seriesParams,
    valueAxes: stateParams.valueAxes,
    vis: vis,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_value_axes_panel.ValueAxesPanel, {
    addValueAxis: addValueAxis,
    removeValueAxis: removeValueAxis,
    onValueAxisPositionChanged: onValueAxisPositionChanged,
    setParamByIndex: setParamByIndex,
    setMultipleValidity: props.setMultipleValidity,
    seriesParams: stateParams.seriesParams,
    valueAxes: stateParams.valueAxes,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_category_axis_panel.CategoryAxisPanel, {
    axis: stateParams.categoryAxes[0],
    onPositionChanged: onCategoryAxisPositionChanged,
    setCategoryAxis: setCategoryAxis,
    disableAxisControls: disableAxisControls,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 7
    }
  })) : null;
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;