"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoryAxisPanel = CategoryAxisPanel;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/vis-default-editor-plugin/public");
var _label_options = require("./label_options");
var _collections = require("../../../collections");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/xy/public/editor/components/options/metrics_axes/category_axis_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const positions = (0, _collections.getPositions)();
function CategoryAxisPanel({
  axis,
  onPositionChanged,
  setCategoryAxis,
  disableAxisControls
}) {
  const setAxis = (0, _react.useCallback)((paramName, value) => {
    const updatedAxis = {
      ...axis,
      [paramName]: value
    };
    setCategoryAxis(updatedAxis);
  }, [setCategoryAxis, axis]);
  const setPosition = (0, _react.useCallback)((paramName, value) => {
    setAxis(paramName, value);
    onPositionChanged(value);
  }, [setAxis, onPositionChanged]);
  const setAxisLabel = (0, _react.useCallback)((paramName, value) => {
    const labels = {
      ...axis.labels,
      [paramName]: value
    };
    setAxis('labels', labels);
  }, [axis.labels, setAxis]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeXy.controls.pointSeries.categoryAxis.xAxisTitle",
    defaultMessage: "X-axis",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.SelectOption, {
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.categoryAxis.positionLabel', {
      defaultMessage: 'Position'
    }),
    options: positions,
    paramName: "position",
    value: axis.position,
    setValue: setPosition,
    "data-test-subj": "categoryAxisPosition",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.SwitchOption, {
    label: _i18n.i18n.translate('visTypeXy.controls.pointSeries.categoryAxis.showLabel', {
      defaultMessage: 'Show axis lines and labels'
    }),
    paramName: "show",
    value: axis.show,
    setValue: setAxis,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }), axis.show && /*#__PURE__*/_react.default.createElement(_label_options.LabelOptions, {
    axisLabels: axis.labels,
    axisFilterCheckboxName: `xAxisFilterLabelsCheckbox${axis.id}`,
    setAxisLabel: setAxisLabel,
    disableAxisControls: disableAxisControls,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }));
}