"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addToSiri = addToSiri;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getAggId = accessor => {
  var _split$pop;
  return (_split$pop = (accessor !== null && accessor !== void 0 ? accessor : '').split('-').pop()) !== null && _split$pop !== void 0 ? _split$pop : '';
};
function addToSiri(series, point, id, yLabel, yFormat, zFormat, zLabel) {
  id = id == null ? '' : id + '';
  if (series.has(id)) {
    series.get(id).values.push(point);
    return;
  }
  series.set(id, {
    id: getAggId(id),
    rawId: id,
    label: yLabel == null ? id : yLabel,
    count: 0,
    values: [point],
    format: yFormat,
    zLabel,
    zFormat
  });
}