"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flattenData = flattenData;
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/*
 * Accepts a Kibana data object, flattens the data.series values array,
 * and returns an array of values objects.
 */
function flattenData(obj) {
  let charts;
  if (!_lodash.default.isObject(obj) || !obj.rows && !obj.columns && !obj.series) {
    throw new TypeError('flattenData expects an object with a series, rows, or columns key');
  }
  if (!obj.series) {
    charts = obj.rows ? obj.rows : obj.columns;
  }
  return (0, _lodash.default)(charts ? charts : [obj]).map('series').flattenDeep().map('values').flattenDeep().filter(Boolean).value();
}