"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisLegendItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/charts-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/vislib/public/vislib/components/legend/legend_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const VisLegendItemComponent = ({
  item,
  selected,
  canFilter,
  anchorPosition,
  onFilter,
  onSelect,
  onHighlight,
  onUnhighlight,
  setColor,
  getColor
}) => {
  const [idToSelectedMap, setIdToSelectedMap] = (0, _react.useState)({});
  /**
   * Keydown listener for a legend entry.
   * This will close the details panel of this legend entry when pressing Escape.
   */
  const onLegendEntryKeydown = event => {
    if (event.key === _eui.keys.ESCAPE) {
      event.preventDefault();
      event.stopPropagation();
      onSelect(null)();
    }
  };
  const filterOptions = [{
    id: 'filterIn',
    label: _i18n.i18n.translate('visTypeVislib.vislib.legend.filterForValueButtonAriaLabel', {
      defaultMessage: 'Filter for {legendDataLabel}',
      values: {
        legendDataLabel: item.label
      }
    }),
    iconType: 'plusInCircle',
    'data-test-subj': `legend-${item.label}-filterIn`
  }, {
    id: 'filterOut',
    label: _i18n.i18n.translate('visTypeVislib.vislib.legend.filterOutValueButtonAriaLabel', {
      defaultMessage: 'Filter out {legendDataLabel}',
      values: {
        legendDataLabel: item.label
      }
    }),
    iconType: 'minusInCircle',
    'data-test-subj': `legend-${item.label}-filterOut`
  }];
  const handleFilterChange = id => {
    setIdToSelectedMap({
      filterIn: id === 'filterIn',
      filterOut: id === 'filterOut'
    });
    onFilter(item, id !== 'filterIn');
  };
  const renderFilterBar = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    type: "multi",
    isIconOnly: true,
    isFullWidth: true,
    legend: _i18n.i18n.translate('visTypeVislib.vislib.legend.filterOptionsLegend', {
      defaultMessage: '{legendDataLabel}, filter options',
      values: {
        legendDataLabel: item.label
      }
    }),
    options: filterOptions,
    onChange: handleFilterChange,
    "data-test-subj": `legend-${item.label}-filters`,
    idToSelectedMap: idToSelectedMap,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }));
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    color: "text",
    flush: "left",
    className: "visLegend__button",
    onKeyDown: onLegendEntryKeydown,
    onMouseEnter: onHighlight,
    onFocus: onHighlight,
    onClick: onSelect(item.label),
    onMouseLeave: onUnhighlight,
    onBlur: onUnhighlight,
    "data-label": item.label,
    title: item.label,
    "aria-label": _i18n.i18n.translate('visTypeVislib.vislib.legend.toggleOptionsButtonAriaLabel', {
      defaultMessage: '{legendDataLabel}, toggle options',
      values: {
        legendDataLabel: item.label
      }
    }),
    "data-test-subj": `legend-${item.label}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "dot",
    color: getColor(item.label),
    "data-test-subj": `legendSelectedColor-${getColor(item.label)}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "visLegend__valueTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, item.label));
  const renderDetails = () => /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    display: "block",
    button: button,
    isOpen: selected,
    anchorPosition: anchorPosition,
    closePopover: onSelect(null),
    panelPaddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 5
    }
  }, canFilter && renderFilterBar(), /*#__PURE__*/_react.default.createElement(_public.ColorPicker, {
    label: item.label,
    color: getColor(item.label),
    onChange: (c, e) => setColor(item.label, c, e),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement("li", {
    key: item.label,
    className: "visLegend__value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 5
    }
  }, renderDetails());
};
const VisLegendItem = exports.VisLegendItem = /*#__PURE__*/(0, _react.memo)(VisLegendItemComponent);