"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _analytics = require("@kbn/analytics");
var _react2 = require("@emotion/react");
var _vis_controller = require("./vis_controller");
var _services = require("./services");
var _vis_wrapper = require("./vis_wrapper.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/vislib/public/vis_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/** @internal **/
const extractContainerType = context => {
  if (context) {
    var _recursiveGet;
    const recursiveGet = item => {
      if (item.type) {
        return item;
      } else if (item.child) {
        return recursiveGet(item.child);
      }
    };
    return (_recursiveGet = recursiveGet(context)) === null || _recursiveGet === void 0 ? void 0 : _recursiveGet.type;
  }
};
const visWrapperStyles = {
  base: (0, _react2.css)({
    display: 'flex',
    flex: '1 1 auto',
    minHeight: 0,
    minWidth: 0
  }),
  wrapper: (0, _react2.css)({
    position: 'relative'
  }),
  container: (0, _react2.css)({
    position: 'absolute',
    top: 0,
    right: 0,
    bottom: 0,
    left: 0
  })
};
const VislibWrapper = ({
  core,
  charts,
  visData,
  visConfig,
  handlers
}) => {
  const chartDiv = (0, _react.useRef)(null);
  const visController = (0, _react.useRef)(null);
  const skipRenderComplete = (0, _react.useRef)(true);
  const renderComplete = (0, _react.useCallback)(() => {
    if (skipRenderComplete.current) {
      return;
    }
    const usageCollection = (0, _services.getUsageCollectionStart)();
    const containerType = extractContainerType(handlers.getExecutionContext());
    if (usageCollection && containerType) {
      usageCollection.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, `render_agg_based_${visConfig.type}`);
    }
    handlers.done();
    skipRenderComplete.current = true;
  }, [handlers, visConfig]);
  const renderChart = (0, _react.useMemo)(() => (0, _lodash.debounce)(() => {
    if (visController.current) {
      visController.current.render(visData, visConfig, handlers, renderComplete);
    }
  }, 100), [handlers, renderComplete, visConfig, visData]);
  const onResize = (0, _react.useCallback)(() => {
    renderChart();
  }, [renderChart]);
  (0, _react.useEffect)(() => {
    skipRenderComplete.current = false;
    renderChart();
  }, [renderChart]);
  (0, _react.useEffect)(() => {
    if (chartDiv.current) {
      const Controller = (0, _vis_controller.createVislibVisController)(core, charts);
      visController.current = new Controller(chartDiv.current);
    }
    return () => {
      var _visController$curren;
      (_visController$curren = visController.current) === null || _visController$curren === void 0 ? void 0 : _visController$curren.destroy();
      visController.current = null;
    };
  }, [core, charts]);
  (0, _react.useEffect)(() => {
    if (handlers.uiState) {
      const uiState = handlers.uiState;
      uiState.on('change', renderChart);
      return () => {
        uiState === null || uiState === void 0 ? void 0 : uiState.off('change', renderChart);
      };
    }
  }, [handlers.uiState, renderChart]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_vis_wrapper.GlobalVislibWrapperStyles, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: onResize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    className: "vislib__wrapper",
    ref: resizeRef,
    css: [visWrapperStyles.base, visWrapperStyles.wrapper],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "vislib__container",
    ref: chartDiv,
    css: [visWrapperStyles.base, visWrapperStyles.container],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }))));
};

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
exports.default = VislibWrapper;
module.exports = exports.default;