"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.vegaBaseViewStyles = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// Note that these are globally-set styles, due to vega_base_view being vanilla JS/non-React
const vegaBaseViewStyles = euiThemeContext => {
  const {
    euiTheme
  } = euiThemeContext;
  return (0, _react.css)`
    .vgaVis {
      display: flex;
      flex: 1 1 100%;
      position: relative;
      // flex-direction determined by js
      &.vgaVis .maplibregl-canvas-container {
        cursor: auto;
      }
    }

    .vgaVis--autoresize {
      ${(0, _eui.euiScrollBarStyles)(euiThemeContext)};
      ${(0, _eui.logicalCSS)('max-width', '100%')}
      ${(0, _eui.logicalCSS)('max-height', '100%')}
      overflow: auto;
    }

    .vgaVis__view {
      z-index: 0;
      flex: 1 1 100%;

      display: block;

      canvas {
        display: block;
      }

      // BUG #23514: Make sure Vega doesn't display the controls in two places
      .vega-bindings {
        display: none !important;
      }
    }

    .vgaVis__controls {
      ${(0, _eui.euiFontSize)(euiThemeContext, 's')}
      display: flex;

      &:not(:empty) {
        // Adding a little bit of padding helps with the unnecessary scrollbars
        ${(0, _eui.logicalCSS)('padding-vertical', euiTheme.size.s)}
        ${(0, _eui.logicalCSS)('padding-horizontal', 0)}
      }

      &.vgaVis__controls--column {
        flex-direction: column;
      }

      &.vgaVis__controls--row {
        flex-direction: row;

        > .vega-bind {
          flex-grow: 1;
        }
      }

      > .vega-bind {
        .vega-bind-name {
          display: inline-block;
          ${(0, _eui.logicalCSS)('width', (0, _eui.mathWithUnits)(euiTheme.size.m, x => x * 10 - euiTheme.base))}
        }

        input[type='range'] {
          ${(0, _eui.logicalCSS)('width', (0, _eui.mathWithUnits)(euiTheme.size.m, x => x * 10))}
          display: inline-block;
          vertical-align: middle;
        }

        label {
          margin: 0;
          ${(0, _eui.logicalCSS)('margin-left', euiTheme.size.s)}
        }

        select {
          ${(0, _eui.logicalCSS)('max-width', (0, _eui.mathWithUnits)(euiTheme.size.base, x => x * 10))}
        }

        .vega-bind-radio label {
          ${(0, _eui.logicalCSS)('margin-vertical', 0)}
          ${(0, _eui.logicalCSS)('margin-right', euiTheme.size.s)}
          ${(0, _eui.logicalCSS)('margin-left', euiTheme.size.xs)}
        }
      }
    }

    // Messages

    .vgaVis__messages {
      position: absolute;
      ${(0, _eui.logicalCSS)('top', 0)}
      ${(0, _eui.logicalCSS)('width', '100%')}
      margin: auto;
      opacity: 0.8;
      z-index: 1;
      list-style: none;
    }

    .vgaVis__message {
      margin: ${euiTheme.size.s};

      .vgaVis__messageCode {
        white-space: pre-wrap;
        padding: ${euiTheme.size.s};
      }
    }

    .vgaVis__message--warn .vgaVis__messageCode {
      background-color: ${(0, _eui.euiBackgroundColor)(euiThemeContext, 'warning')};
      color: ${euiTheme.colors.warningText};
    }

    .vgaVis__message--err .vgaVis__messageCode {
      background-color: ${(0, _eui.euiBackgroundColor)(euiThemeContext, 'danger')};
      color: ${euiTheme.colors.dangerText};
    }
  `;
};
exports.vegaBaseViewStyles = vegaBaseViewStyles;