"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/vega/public/vega_inspector/vega_data_inspector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const dataSetsLabel = _i18n.i18n.translate('visTypeVega.inspector.dataSetsLabel', {
  defaultMessage: 'Data sets'
});
const signalValuesLabel = _i18n.i18n.translate('visTypeVega.inspector.signalValuesLabel', {
  defaultMessage: 'Signal values'
});
const specLabel = _i18n.i18n.translate('visTypeVega.inspector.specLabel', {
  defaultMessage: 'Spec'
});
const vegaDataInspectorStyles = {
  base: (0, _react2.css)({
    height: '100%',
    // TODO: EUI needs to provide props to pass down from EuiTabbedContent to tabs and content
    display: 'flex',
    flexDirection: 'column',
    "[role='tablist']": {
      flexShrink: 0
    },
    "[role='tabpanel']": {
      flexGrow: 1
    }
  }),
  specViewer: (0, _react2.css)({
    height: '100%'
  })
};
const VegaDataInspector = ({
  adapters
}) => {
  const [error, setError] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    const subscription = adapters.vega.getErrorObservable().subscribe(data => {
      setError(data);
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [adapters.vega]);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('visTypeVega.inspector.errorHeading', {
        defaultMessage: `Vega didn't render successfully`
      }),
      color: "danger",
      iconType: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 9
      }
    }, error));
  }
  const tabs = [{
    id: 'data-viewer--id',
    name: dataSetsLabel,
    content: /*#__PURE__*/_react.default.createElement(_components.DataViewer, {
      vegaAdapter: adapters.vega,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 16
      }
    }),
    'data-test-subj': 'vegaDataInspectorDataViewerButton'
  }, {
    id: 'signal-viewer--id',
    name: signalValuesLabel,
    content: /*#__PURE__*/_react.default.createElement(_components.SignalViewer, {
      vegaAdapter: adapters.vega,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 16
      }
    }),
    'data-test-subj': 'vegaDataInspectorSignalViewerButton'
  }, {
    id: 'spec-viewer--id',
    name: specLabel,
    content: /*#__PURE__*/_react.default.createElement(_components.SpecViewer, {
      vegaAdapter: adapters.vega,
      css: vegaDataInspectorStyles.specViewer,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 16
      }
    }),
    'data-test-subj': 'vegaDataInspectorSpecViewerButton'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    size: "s",
    tabs: tabs,
    initialSelectedTab: tabs[0],
    autoFocus: "selected",
    css: vegaDataInspectorStyles.base,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  });
};

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
exports.default = VegaDataInspector;
module.exports = exports.default;