"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _inspector_data_grid = require("./inspector_data_grid");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/vega/public/vega_inspector/components/data_viewer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getDataGridArialabel = view => _i18n.i18n.translate('visTypeVega.inspector.dataViewer.gridAriaLabel', {
  defaultMessage: '{name} data grid',
  values: {
    name: view.id
  }
});
const dataSetAriaLabel = _i18n.i18n.translate('visTypeVega.inspector.dataViewer.dataSetAriaLabel', {
  defaultMessage: 'Data set'
});
const DataViewer = ({
  vegaAdapter,
  ...rest
}) => {
  const [inspectDataSets, setInspectDataSets] = (0, _react.useState)([]);
  const [selectedView, setSelectedView] = (0, _react.useState)();
  const [dataGridAriaLabel, setDataGridAriaLabel] = (0, _react.useState)('');
  const onViewChange = (0, _react.useCallback)(selectedOptions => {
    const newView = inspectDataSets.find(view => view.id === selectedOptions[0].label);
    if (newView) {
      setDataGridAriaLabel(getDataGridArialabel(newView));
      setSelectedView(newView);
    }
  }, [inspectDataSets]);
  (0, _react.useEffect)(() => {
    const subscription = vegaAdapter.getDataSetsSubscription().subscribe(dataSets => {
      setInspectDataSets(dataSets);
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [vegaAdapter]);
  (0, _react.useEffect)(() => {
    if (inspectDataSets) {
      if (!selectedView) {
        setSelectedView(inspectDataSets[0]);
      } else {
        setDataGridAriaLabel(getDataGridArialabel(selectedView));
      }
    }
  }, [selectedView, inspectDataSets]);
  if (!selectedView) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
    direction: "column",
    gutterSize: "s",
    wrap: false,
    responsive: false
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    options: inspectDataSets.map(item => ({
      label: item.id
    })),
    "aria-label": dataSetAriaLabel,
    onChange: onViewChange,
    isClearable: false,
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: [{
      label: selectedView.id
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_inspector_data_grid.InspectorDataGrid, {
    columns: selectedView.columns,
    data: selectedView.data,
    dataGridAriaLabel: dataGridAriaLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  })));
};
exports.DataViewer = DataViewer;