"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extendSearchParamsWithRuntimeFields = exports.SearchAPI = void 0;
var _rxjs = require("rxjs");
var _public = require("@kbn/data-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @internal **/
const extendSearchParamsWithRuntimeFields = async (indexPatterns, requestParams, indexPatternString) => {
  if (indexPatternString) {
    let runtimeMappings = requestParams.runtime_mappings;
    if (!runtimeMappings) {
      const indexPattern = (await indexPatterns.find(indexPatternString, 1)).find(index => index.title === indexPatternString);
      runtimeMappings = indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.getRuntimeMappings();
    }
    return {
      ...requestParams,
      runtime_mappings: runtimeMappings
    };
  }
  return requestParams;
};
exports.extendSearchParamsWithRuntimeFields = extendSearchParamsWithRuntimeFields;
class SearchAPI {
  constructor(dependencies, abortSignal, inspectorAdapters, searchSessionId, executionContext) {
    this.dependencies = dependencies;
    this.abortSignal = abortSignal;
    this.inspectorAdapters = inspectorAdapters;
    this.searchSessionId = searchSessionId;
    this.executionContext = executionContext;
  }
  search(searchRequests) {
    const {
      search,
      indexPatterns
    } = this.dependencies;
    const requestResponders = {};
    return (0, _rxjs.combineLatest)(searchRequests.map(request => {
      const {
        name: requestId,
        ...restRequest
      } = request;
      const requestParams = (0, _public.getSearchParamsFromRequest)(restRequest, {
        getConfig: this.dependencies.uiSettings.get.bind(this.dependencies.uiSettings)
      });
      return (0, _rxjs.from)(extendSearchParamsWithRuntimeFields(indexPatterns, requestParams, `${request.index}`)).pipe((0, _rxjs.tap)(params => {
        /** inspect request data **/
        if (this.inspectorAdapters) {
          requestResponders[requestId] = this.inspectorAdapters.requests.start(requestId, {
            ...request,
            searchSessionId: this.searchSessionId
          });
          requestResponders[requestId].json(params);
        }
      }), (0, _rxjs.switchMap)(params => search.search({
        params
      }, {
        abortSignal: this.abortSignal,
        sessionId: this.searchSessionId,
        executionContext: this.executionContext
      }).pipe((0, _rxjs.tap)(data => this.inspectSearchResult(data, requestResponders[requestId]), err => this.inspectSearchResult({
        rawResponse: err === null || err === void 0 ? void 0 : err.err
      }, requestResponders[requestId])), (0, _rxjs.map)(data => ({
        name: requestId,
        rawResponse: structuredClone(data.rawResponse)
      })))));
    }));
  }
  resetSearchStats() {
    if (this.inspectorAdapters) {
      this.inspectorAdapters.requests.reset();
    }
  }
  inspectSearchResult(response, requestResponder) {
    if (requestResponder) {
      requestResponder.stats(_public.search.getResponseInspectorStats(response.rawResponse)).ok({
        json: response.rawResponse
      });
    }
  }
}
exports.SearchAPI = SearchAPI;