"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = VegaVisEditor;
var _monaco = require("@kbn/monaco");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _hjson = _interopRequireDefault(require("hjson"));
var _react = _interopRequireWildcard(require("react"));
var _jsonStringifyPrettyCompact = _interopRequireDefault(require("json-stringify-pretty-compact"));
var _i18n = require("@kbn/i18n");
var _codeEditor = require("@kbn/code-editor");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _services = require("../services");
var _vega_help_menu = require("./vega_help_menu");
var _vega_actions_menu = require("./vega_actions_menu");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/vega/public/components/vega_vis_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function format(value, stringify, options) {
  try {
    const spec = _hjson.default.parse(value, {
      legacyRoot: false,
      keepWsc: true
    });
    return {
      value: stringify(spec, options),
      isValid: true
    };
  } catch (err) {
    // This is a common case - user tries to format an invalid HJSON text
    (0, _services.getNotifications)().toasts.addError(err, {
      title: _i18n.i18n.translate('visTypeVega.editor.formatError', {
        defaultMessage: 'Error formatting spec'
      })
    });
    return {
      value,
      isValid: false
    };
  }
}
const vegaVisStyles = {
  base: (0, _react2.css)({
    '&.vgaEditor': {
      width: '100%',
      flexGrow: 1,
      '.kibanaCodeEditor': {
        width: '100%'
      }
    }
  }),
  editorActions: ({
    euiTheme
  }) => (0, _react2.css)({
    position: 'absolute',
    zIndex: euiTheme.levels.flyout,
    top: euiTheme.size.s,
    // Adjust for sidebar collapse button
    right: euiTheme.size.xxl,
    lineHeight: 1
  })
};
const monacoOverride = {
  override: ({
    colorMode
  }) => (0, _react2.css)({
    // See discussion: https://github.com/elastic/kibana/issues/228296#issuecomment-3126033291
    ...(colorMode === 'DARK' && {
      '.monaco-editor': {
        '--vscode-editor-inactiveSelectionBackground': '#3a3d41'
      }
    })
  })
};
function VegaVisEditor({
  stateParams,
  setValue
}) {
  const styles = (0, _use_memo_css.useMemoCss)(vegaVisStyles);
  const monacoStyles = (0, _use_memo_css.useMemoCss)(monacoOverride);
  const [languageId, setLanguageId] = (0, _react.useState)();
  (0, _useMount.default)(() => {
    let specLang = _monaco.XJsonLang.ID;
    try {
      JSON.parse(stateParams.spec);
    } catch {
      specLang = _codeEditor.HJSON_LANG_ID;
    }
    setLanguageId(specLang);
  });
  const setSpec = (0, _react.useCallback)((value, specLang) => {
    setValue('spec', value);
    if (specLang) {
      setLanguageId(specLang);
    }
  }, [setValue]);
  const onChange = (0, _react.useCallback)(value => setSpec(value), [setSpec]);
  const formatJson = (0, _react.useCallback)(() => {
    const {
      value,
      isValid
    } = format(stateParams.spec, _jsonStringifyPrettyCompact.default);
    if (isValid) {
      setSpec(value, _monaco.XJsonLang.ID);
    }
  }, [setSpec, stateParams.spec]);
  const formatHJson = (0, _react.useCallback)(() => {
    const {
      value,
      isValid
    } = format(stateParams.spec, _hjson.default.stringify, {
      bracesSameLine: true,
      keepWsc: true
    });
    if (isValid) {
      setSpec(value, _codeEditor.HJSON_LANG_ID);
    }
  }, [setSpec, stateParams.spec]);
  if (!languageId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "vgaEditor",
    "data-test-subj": "vega-editor",
    css: styles.base,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "vgaEditor__editorActions",
    css: styles.editorActions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_vega_help_menu.VegaHelpMenu, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_vega_actions_menu.VegaActionsMenu, {
    formatHJson: formatHJson,
    formatJson: formatJson,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    classNameCss: monacoStyles.override,
    width: "100%",
    height: "100%",
    languageId: languageId,
    value: stateParams.spec,
    onChange: onChange,
    options: {
      lineNumbers: 'on',
      fontSize: 12,
      minimap: {
        enabled: false
      },
      folding: true,
      wordWrap: 'on',
      wrappingIndent: 'indent',
      automaticLayout: true
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }));
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;