"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBaseTheme = getBaseTheme;
exports.getChartClasses = getChartClasses;
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _charts = require("@elastic/charts");
var _coloring = require("@kbn/coloring");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const colorValidationOption = {
  shouldBeCompatibleWithColorJs: true
};
function getAAARelativeLum(bgColor, fgColor, ratio = 7) {
  const relLum1 = (0, _coloring.getValidColor)(bgColor, colorValidationOption).luminance();
  const relLum2 = (0, _coloring.getValidColor)(fgColor, colorValidationOption).luminance();
  if (relLum1 > relLum2) {
    // relLum1 is brighter, relLum2 is darker
    return (relLum1 + 0.05 - ratio * 0.05) / ratio;
  } else {
    // relLum1 is darker, relLum2 is brighter
    return Math.min(ratio * (relLum1 + 0.05) - 0.05, 1);
  }
}
function getGrayFromRelLum(relLum) {
  if (relLum <= 0.0031308) {
    return relLum * 12.92;
  } else {
    return (1.0 + 0.055) * Math.pow(relLum, 1.0 / 2.4) - 0.055;
  }
}
function getGrayRGBfromGray(gray) {
  const g = Math.round(gray * 255);
  return `rgb(${g},${g},${g})`;
}
function getAAAGray(bgColor, fgColor, ratio = 7) {
  const relLum = getAAARelativeLum(bgColor, fgColor, ratio);
  const gray = getGrayFromRelLum(relLum);
  return getGrayRGBfromGray(gray);
}
function findBestContrastColor(bgColor, lightFgColor, darkFgColor, ratio = 4.5) {
  const lc = _chromaJs.default.contrast(bgColor, lightFgColor);
  const dc = _chromaJs.default.contrast(bgColor, darkFgColor);
  if (lc >= dc) {
    if (lc >= ratio) {
      return lightFgColor;
    }
    return getAAAGray(bgColor, lightFgColor, ratio);
  }
  if (dc >= ratio) {
    return darkFgColor;
  }
  return getAAAGray(bgColor, darkFgColor, ratio);
}
function isValidColor(color) {
  if (typeof color !== 'string') {
    return false;
  }
  if (color.length === 0) {
    return false;
  }
  try {
    const finalColor = (0, _coloring.getValidColor)(color, colorValidationOption);
    return finalColor != null;
  } catch {
    return false;
  }
}

/**
 * compute base chart theme based on the background color
 *
 * @param baseTheme
 * @param bgColor
 */
function getBaseTheme(baseTheme, bgColor) {
  if (!isValidColor(bgColor)) {
    return baseTheme;
  }
  const bgLuminosity = (0, _coloring.getValidColor)(bgColor, colorValidationOption).luminance();
  // TODO check if this still apply
  const mainTheme = bgLuminosity <= 0.179 ? _charts.LEGACY_DARK_THEME : _charts.LEGACY_LIGHT_THEME;
  const color = findBestContrastColor(bgColor, _charts.LEGACY_LIGHT_THEME.axes.axisTitle.fill, _charts.LEGACY_DARK_THEME.axes.axisTitle.fill);
  return {
    ...mainTheme,
    axes: {
      ...mainTheme.axes,
      axisTitle: {
        ...mainTheme.axes.axisTitle,
        fill: color
      },
      tickLabel: {
        ...mainTheme.axes.tickLabel,
        fill: color
      },
      axisLine: {
        ...mainTheme.axes.axisLine,
        stroke: color
      },
      tickLine: {
        ...mainTheme.axes.tickLine,
        stroke: color
      }
    }
  };
}
function getChartClasses(bgColor) {
  // keep the original theme color if no bg color is specified
  if (typeof bgColor !== 'string') {
    return;
  }
  const bgLuminosity = (0, _coloring.getValidColor)(bgColor, colorValidationOption).luminance();
  return bgLuminosity <= 0.179 ? 'tvbVisTimeSeriesDark' : 'tvbVisTimeSeriesLight';
}