"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.annotationTooltipStyle = exports.annotationStyle = exports.annotationLineStyle = exports.annotationIconStyle = exports.Annotation = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/visualizations/views/annotation.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const annotationStyle = exports.annotationStyle = (0, _react2.css)`
  position: absolute;
  z-index: 90; // Specific to not overlap chart tooltip
  display: flex;
  flex-direction: column;
  align-items: center;
`;
const annotationLineStyle = exports.annotationLineStyle = (0, _react2.css)`
  flex: 1 0 auto;
  width: 2px;
`;
const annotationIconStyle = ({
  euiTheme
}) => (0, _react2.css)`
  flex: 0 0 auto;
  width: ${euiTheme.size.m};
  text-align: center;
`;
exports.annotationIconStyle = annotationIconStyle;
const annotationTooltipStyle = ({
  euiTheme
}) => (0, _react2.css)`
  ${(0, _eui.euiFontSize)({
  euiTheme
}, 'xs')};
  padding: ${euiTheme.size.s};
  animation-duration: 0s;
  animation-delay: 0s;
`;
exports.annotationTooltipStyle = annotationTooltipStyle;
class Annotation extends _react.Component {
  constructor(props) {
    super(props);
  }
  renderTooltip() {
    const [timestamp, messageSource] = this.props.series;
    const messages = messageSource.map((message, i) => {
      return /*#__PURE__*/_react.default.createElement("div", {
        key: `${message}-${i}`,
        className: "tvbVisAnnotation__message",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 9
        }
      }, message);
    });
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbTooltip__timestamp",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }, (0, _moment.default)(timestamp).format('lll')), messages);
  }
  render() {
    const {
      color,
      plot,
      icon,
      series
    } = this.props;
    const offset = plot.pointOffset({
      x: series[0],
      y: 0
    });
    const tooltip = this.renderTooltip();
    const containerCSS = (0, _react2.css)`
      left: ${offset.left - 6}px;
      bottom: 0;
      top: 5px;
    `;
    const lineCSS = (0, _react2.css)`
      backgroundcolor: ${color};
    `;
    const iconCSS = (0, _react2.css)`
      color: ${color};
    `;
    return /*#__PURE__*/_react.default.createElement("div", {
      css: [containerCSS, annotationStyle],
      className: "tvbVisAnnotation",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: [lineCSS, annotationLineStyle],
      className: "tvbVisAnnotation__line",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      css: annotationTooltipStyle,
      className: "tvbVisAnnotation__tooltip",
      content: tooltip,
      position: "top",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("i", {
      css: [iconCSS, annotationIconStyle],
      className: `tvbVisAnnotation__icon fa ${icon}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 11
      }
    })));
  }
}
exports.Annotation = Annotation;
Annotation.propTypes = {
  series: _propTypes.default.array,
  icon: _propTypes.default.string,
  color: _propTypes.default.string,
  plot: _propTypes.default.object
};