"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YesNo = YesNo;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/yes_no.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function YesNo({
  name,
  value,
  disabled,
  'data-test-subj': dataTestSubj = name,
  onChange
}) {
  const handleChange = (0, _react.useCallback)(val => {
    return () => onChange({
      [name]: val
    });
  }, [onChange, name]);
  const htmlId = (0, _eui.htmlIdGenerator)();
  const inputName = htmlId(name);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    id: htmlId('yes'),
    "data-test-subj": `${dataTestSubj}-yes`,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.yesButtonLabel",
      defaultMessage: "Yes",
      description: "The 'yes' in a yes/no answer choice.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 11
      }
    }),
    className: "eui-displayInlineBlock",
    name: inputName,
    checked: Boolean(value),
    value: "yes",
    onChange: handleChange(1),
    disabled: disabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }), "\u2003", /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    id: htmlId('no'),
    "data-test-subj": `${dataTestSubj}-no`,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.noButtonLabel",
      defaultMessage: "No",
      description: "The 'no' in a yes/no answer choice.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 11
      }
    }),
    className: "eui-displayInlineBlock",
    name: inputName,
    checked: !Boolean(value),
    value: "no",
    onChange: handleChange(0),
    disabled: disabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }));
}