"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeseriesConfig = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _enums = require("../../../../../common/enums");
var _data_format_picker = require("../../data_format_picker");
var _create_select_handler = require("../../lib/create_select_handler");
var _create_number_handler = require("../../lib/create_number_handler");
var _yes_no = require("../../yes_no");
var _create_text_handler = require("../../lib/create_text_handler");
var _index_pattern = require("../../index_pattern");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _series_config_query_bar_with_ignore_global_filter = require("../../series_config_query_bar_with_ignore_global_filter");
var _palette_picker = require("../../palette_picker");
var _services = require("../../../../services");
var _check_if_numeric_metric = require("../../lib/check_if_numeric_metric");
var _stacked = require("../../lib/stacked");
var _chart = require("../../../visualizations/constants/chart");
var _common = require("../../../styles/common.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/vis_types/timeseries/config.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TimeseriesConfig = exports.TimeseriesConfig = (0, _i18nReact.injectI18n)(function (props) {
  var _model$palette;
  const handleSelectChange = (0, _create_select_handler.createSelectHandler)(props.onChange);
  const handleTextChange = (0, _create_text_handler.createTextHandler)(props.onChange);
  const handleNumberChange = (0, _create_number_handler.createNumberHandler)(props.onChange);
  const defaults = {
    value_template: '{{value}}',
    offset_time: '',
    axis_min: undefined,
    axis_max: undefined,
    stacked: _chart.STACKED_OPTIONS.NONE,
    steps: 0
  };
  const model = {
    ...defaults,
    ...props.model
  };
  const htmlId = (0, _eui.htmlIdGenerator)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    intl
  } = props;
  const stackedOptions = [{
    label: intl.formatMessage({
      id: 'visTypeTimeseries.timeSeries.noneLabel',
      defaultMessage: 'None'
    }),
    value: _chart.STACKED_OPTIONS.NONE
  }, {
    label: intl.formatMessage({
      id: 'visTypeTimeseries.timeSeries.stackedLabel',
      defaultMessage: 'Stacked'
    }),
    value: _chart.STACKED_OPTIONS.STACKED
  }, {
    label: intl.formatMessage({
      id: 'visTypeTimeseries.timeSeries.stackedWithinSeriesLabel',
      defaultMessage: 'Stacked within series'
    }),
    value: _chart.STACKED_OPTIONS.STACKED_WITHIN_SERIES
  }, {
    label: intl.formatMessage({
      id: 'visTypeTimeseries.timeSeries.percentLabel',
      defaultMessage: 'Percent'
    }),
    value: _chart.STACKED_OPTIONS.PERCENT,
    disabled: (0, _stacked.isPercentDisabled)(props.seriesQuantity[model.id])
  }];
  const selectedStackedOption = stackedOptions.find(option => {
    return model.stacked === option.value;
  });
  const positionOptions = [{
    label: intl.formatMessage({
      id: 'visTypeTimeseries.timeSeries.rightLabel',
      defaultMessage: 'Right'
    }),
    value: 'right'
  }, {
    label: intl.formatMessage({
      id: 'visTypeTimeseries.timeSeries.leftLabel',
      defaultMessage: 'Left'
    }),
    value: 'left'
  }];
  const selectedAxisPosOption = positionOptions.find(option => {
    return model.axis_position === option.value;
  });
  const chartTypeOptions = [{
    label: intl.formatMessage({
      id: 'visTypeTimeseries.timeSeries.barLabel',
      defaultMessage: 'Bar'
    }),
    value: 'bar'
  }, {
    label: intl.formatMessage({
      id: 'visTypeTimeseries.timeSeries.lineLabel',
      defaultMessage: 'Line'
    }),
    value: 'line'
  }];
  const selectedChartTypeOption = chartTypeOptions.find(option => {
    return model.chart_type === option.value;
  });
  const {
    palettes
  } = (0, _services.getCharts)();
  const [palettesRegistry, setPalettesRegistry] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    const fetchPalettes = async () => {
      const palettesService = await palettes.getPalettes();
      setPalettesRegistry(palettesService);
    };
    fetchPalettes();
  }, [palettes]);
  const handlePaletteChange = val => {
    props.onChange({
      split_color_mode: null,
      palette: val
    });
  };
  let type;
  if (model.chart_type === 'line') {
    type = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      responsive: false,
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('chartType'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeSeries.chartLine.chartTypeLabel",
        defaultMessage: "Chart type",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 160,
          columnNumber: 15
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      isClearable: false,
      options: chartTypeOptions,
      selectedOptions: selectedChartTypeOption ? [selectedChartTypeOption] : [],
      onChange: handleSelectChange('chart_type'),
      singleSelection: {
        asPlainText: true
      },
      "data-test-subj": "seriesChartTypeComboBox",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('stacked'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeSeries.chartLine.stackedLabel",
        defaultMessage: "Stacked",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 15
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      isClearable: false,
      options: stackedOptions,
      selectedOptions: selectedStackedOption ? [selectedStackedOption] : [],
      onChange: handleSelectChange('stacked'),
      singleSelection: {
        asPlainText: true
      },
      "data-test-subj": "seriesStackedComboBox",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('fill'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeSeries.chartLine.fillLabel",
        defaultMessage: "Fill (0 to 1)",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 200,
          columnNumber: 15
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      step: 0.1,
      onChange: handleTextChange('fill'),
      value: Number(model.fill),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('lineWidth'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeSeries.chartLine.lineWidthLabel",
        defaultMessage: "Line width",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 217,
          columnNumber: 15
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      onChange: handleTextChange('line_width'),
      value: Number(model.line_width),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 223,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('pointSize'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeSeries.chartLine.pointSizeLabel",
        defaultMessage: "Point size",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 233,
          columnNumber: 15
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      onChange: handleTextChange('point_size'),
      value: Number(model.point_size),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('visTypeTimeseries.timeSeries.chartLine.stepsLabel', {
        defaultMessage: 'Steps'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
      value: model.steps,
      name: "steps",
      onChange: props.onChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 13
      }
    }))));
  }
  if (model.chart_type === 'bar') {
    type = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      responsive: false,
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('chartType'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeSeries.chartBar.chartTypeLabel",
        defaultMessage: "Chart type",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 264,
          columnNumber: 15
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      isClearable: false,
      options: chartTypeOptions,
      selectedOptions: selectedChartTypeOption ? [selectedChartTypeOption] : [],
      onChange: handleSelectChange('chart_type'),
      singleSelection: {
        asPlainText: true
      },
      "data-test-subj": "seriesChartTypeComboBox",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 280,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('stacked'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeSeries.chartBar.stackedLabel",
        defaultMessage: "Stacked",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 284,
          columnNumber: 15
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      isClearable: false,
      options: stackedOptions,
      selectedOptions: selectedStackedOption ? [selectedStackedOption] : [],
      onChange: handleSelectChange('stacked'),
      singleSelection: {
        asPlainText: true
      },
      "data-test-subj": "seriesStackedComboBox",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 290,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 300,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('fill'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeSeries.chartBar.fillLabel",
        defaultMessage: "Fill (0 to 1)",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 304,
          columnNumber: 15
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 301,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      step: 0.1,
      onChange: handleTextChange('fill'),
      value: Number(model.fill),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 310,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 317,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('lineWidth'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeSeries.chartBar.lineWidthLabel",
        defaultMessage: "Line width",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 321,
          columnNumber: 15
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 318,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      onChange: handleTextChange('line_width'),
      value: Number(model.line_width),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 327,
        columnNumber: 13
      }
    }))));
  }
  const disableSeparateYaxis = model.separate_axis ? false : true;
  const seriesIndexPattern = props.model.override_index_pattern ? props.model.series_index_pattern : props.indexPatternForQuery;
  const changeModelFormatter = (0, _react.useCallback)(formatter => props.onChange({
    formatter
  }), [props]);
  const isNumericMetric = (0, _react.useMemo)(() => (0, _check_if_numeric_metric.checkIfNumericMetric)((0, _lodash.last)(model.metrics), props.fields, seriesIndexPattern), [model.metrics, props.fields, seriesIndexPattern]);
  const isKibanaIndexPattern = props.panel.use_kibana_indexes || seriesIndexPattern === '';
  const {
    indexPatternForQuery,
    onChange
  } = props;
  const onChangeOverride = (0, _react.useCallback)(partialState => {
    const stateUpdate = {
      ...partialState
    };
    const isEnabling = partialState.override_index_pattern;
    if (isEnabling && !model.series_index_pattern) {
      stateUpdate.series_index_pattern = indexPatternForQuery;
    }
    onChange(stateUpdate);
  }, [model.series_index_pattern, indexPatternForQuery, onChange]);
  const initialPalette = (_model$palette = model.palette) !== null && _model$palette !== void 0 ? _model$palette : {
    type: 'palette',
    name: 'default'
  };
  const palette = {
    ...initialPalette,
    name: model.split_color_mode === 'kibana' ? 'kibana_palette' : model.split_color_mode || initialPalette.name
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _common.tsvbEditorRowStyles)(euiTheme),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 377,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 378,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_data_format_picker.DataFormatPicker, {
    formatterValue: model.formatter,
    changeModelFormatter: changeModelFormatter,
    shouldIncludeDefaultOption: isKibanaIndexPattern,
    shouldIncludeNumberOptions: isNumericMetric,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 379,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('template'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.timeSeries.templateLabel",
      defaultMessage: "Template",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 389,
        columnNumber: 15
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 395,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.timeSeries.templateHelpText",
      defaultMessage: "eg.{templateExample}",
      values: {
        templateExample: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 399,
            columnNumber: 46
          }
        }, '{{value}}/s')
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 396,
        columnNumber: 17
      }
    })),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    onChange: handleTextChange('value_template'),
    value: model.value_template,
    disabled: model.formatter === _enums.DATA_FORMATTERS.DEFAULT,
    fullWidth: true,
    "data-test-subj": "tsvb_series_value",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 405,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 416,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_series_config_query_bar_with_ignore_global_filter.SeriesConfigQueryBarWithIgnoreGlobalFilter, {
    model: model,
    onChange: props.onChange,
    panel: props.panel,
    indexPatternForQuery: seriesIndexPattern,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 417,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 423,
      columnNumber: 7
    }
  }), type, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 427,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 429,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 430,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('offset'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.timeSeries.offsetSeriesTimeLabel",
      defaultMessage: "Offset series time by (1m, 1h, 1w, 1d)",
      description: "1m, 1h, 1w, 1d are required values and must not be translated.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 434,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 431,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "offsetTimeSeries",
    onChange: handleTextChange('offset_time'),
    value: model.offset_time,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 441,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 448,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('visTypeTimeseries.timeSeries.hideInLegendLabel', {
      defaultMessage: 'Hide in legend'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 449,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
    value: model.hide_in_legend,
    name: "hide_in_legend",
    onChange: props.onChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 454,
      columnNumber: 13
    }
  }))), palettesRegistry && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 458,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('splitColor'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.timeSeries.splitColorThemeLabel",
      defaultMessage: "Split color theme",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 462,
        columnNumber: 17
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 459,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_palette_picker.PalettePicker, {
    palettes: palettesRegistry,
    activePalette: palette,
    setPalette: handlePaletteChange,
    color: model.color,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 468,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 479,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 481,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 482,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('visTypeTimeseries.timeSeries.separateAxisLabel', {
      defaultMessage: 'Separate axis?'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 483,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
    value: model.separate_axis,
    name: "separate_axis",
    onChange: props.onChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 488,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 491,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('axisMin'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.timeSeries.axisMinLabel",
      defaultMessage: "Axis min",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 495,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 492,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    onChange: handleNumberChange('axis_min', {
      isClearable: true
    }),
    value: model.axis_min,
    disabled: disableSeparateYaxis,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 501,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 508,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('axisMax'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.timeSeries.axisMaxLabel",
      defaultMessage: "Axis max",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 512,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 509,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    onChange: handleNumberChange('axis_max', {
      isClearable: true
    }),
    value: model.axis_max,
    disabled: disableSeparateYaxis,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 518,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 525,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('axisPos'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.timeSeries.axisPositionLabel",
      defaultMessage: "Axis position",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 529,
        columnNumber: 15
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 526,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isClearable: false,
    isDisabled: disableSeparateYaxis,
    options: positionOptions,
    selectedOptions: selectedAxisPosOption ? [selectedAxisPosOption] : [],
    onChange: handleSelectChange('axis_position'),
    singleSelection: {
      asPlainText: true
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 535,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 547,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 549,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 550,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('visTypeTimeseries.timeSeries.overrideDataViewLabel', {
      defaultMessage: 'Override data view?'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 551,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
    value: model.override_index_pattern,
    name: "override_index_pattern",
    onChange: onChangeOverride,
    "data-test-subj": "seriesOverrideIndexPattern",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 556,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 564,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_index_pattern.IndexPattern, (0, _extends2.default)({}, props, {
    prefix: "series_",
    disabled: !model.override_index_pattern,
    allowLevelOfDetail: true,
    baseIndexPattern: indexPatternForQuery,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 565,
      columnNumber: 11
    }
  })))));
});
TimeseriesConfig.propTypes = {
  fields: _propTypes.default.object,
  model: _propTypes.default.object,
  panel: _propTypes.default.object,
  onChange: _propTypes.default.func,
  indexPatternForQuery: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string]),
  seriesQuantity: _propTypes.default.object
};