"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.VisEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _rxjs = _interopRequireWildcard(require("rxjs"));
var Rx = _rxjs;
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _vis_editor_visualization = require("./vis_editor_visualization");
var _panel_config = require("./panel_config");
var _index_patterns_utils = require("../../../common/index_patterns_utils");
var _enums = require("../../../common/enums");
var _vis_picker = require("./vis_picker");
var _fetch_fields = require("../lib/fetch_fields");
var _services = require("../../services");
var _use_index_patter_mode_callout = require("./use_index_patter_mode_callout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/vis_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const VIS_STATE_DEBOUNCE_DELAY = 200;
const APP_NAME = 'VisEditor';
class VisEditor extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "abortControllerFetchFields", void 0);
    (0, _defineProperty2.default)(this, "localStorage", void 0);
    (0, _defineProperty2.default)(this, "visDataSubject", void 0);
    (0, _defineProperty2.default)(this, "visData$", void 0);
    (0, _defineProperty2.default)(this, "getConfig", key => {
      return this.props.config.get(key);
    });
    (0, _defineProperty2.default)(this, "updateVisState", (0, _lodash.debounce)(() => {
      this.props.vis.params = this.state.model;
      this.props.embeddableHandler.reload();
      this.props.eventEmitter.emit('dirtyStateChange', {
        isDirty: false
      });
    }, VIS_STATE_DEBOUNCE_DELAY));
    (0, _defineProperty2.default)(this, "abortableFetchFields", extractedIndexPatterns => {
      var _this$abortController;
      (_this$abortController = this.abortControllerFetchFields) === null || _this$abortController === void 0 ? void 0 : _this$abortController.abort();
      this.abortControllerFetchFields = new AbortController();
      return (0, _fetch_fields.fetchFields)(extractedIndexPatterns, this.abortControllerFetchFields.signal);
    });
    (0, _defineProperty2.default)(this, "handleChange", partialModel => {
      if ((0, _lodash.isEmpty)(partialModel)) {
        return;
      }
      const hasTypeChanged = partialModel.type && this.state.model.type !== partialModel.type;
      let dirty = true;
      if (this.state.autoApply || hasTypeChanged) {
        this.updateVisState();
        dirty = false;
      }
      const nextModel = {
        ...this.state.model,
        ...partialModel
      };
      const extractedIndexPatterns = (0, _index_patterns_utils.extractIndexPatternValues)(nextModel, this.getDefaultIndex());
      if (!(0, _lodash.isEqual)(this.state.extractedIndexPatterns, extractedIndexPatterns)) {
        this.abortableFetchFields(extractedIndexPatterns).then(visFields => {
          this.setState({
            visFields,
            extractedIndexPatterns
          });
        });
      }
      this.setState({
        dirty,
        model: nextModel
      });
    });
    (0, _defineProperty2.default)(this, "updateModel", () => {
      const {
        params
      } = this.props.vis.clone();
      this.setState({
        model: params
      });
    });
    (0, _defineProperty2.default)(this, "handleCommit", () => {
      this.updateVisState();
      this.setState({
        dirty: false
      });
    });
    (0, _defineProperty2.default)(this, "handleAutoApplyToggle", event => {
      this.setState({
        autoApply: event.target.checked
      });
    });
    (0, _defineProperty2.default)(this, "onDataChange", data => {
      this.visDataSubject.next(data === null || data === void 0 ? void 0 : data.visData);
    });
    this.localStorage = new _public2.Storage(window.localStorage);
    this.state = {
      autoApply: true,
      dirty: false,
      model: {
        // we should set default value for 'time_range_mode' in model so that when user save visualization
        // we set right mode in savedObject
        // ternary operator needed because old visualization have 'time_range_mode' as undefined for 'last_value'
        // but for creating new visaulization we should use 'entire_timerange' as default.
        [_enums.TIME_RANGE_MODE_KEY]: this.props.vis.title && this.props.vis.params.type !== 'timeseries' ? _enums.TIME_RANGE_DATA_MODES.LAST_VALUE : _enums.TIME_RANGE_DATA_MODES.ENTIRE_TIME_RANGE,
        ...this.props.vis.params,
        series: this.props.vis.params.series.map(val => ({
          [_enums.TIME_RANGE_MODE_KEY]: this.props.vis.title && this.props.vis.params.type !== 'timeseries' && val.override_index_pattern ? _enums.TIME_RANGE_DATA_MODES.LAST_VALUE : _enums.TIME_RANGE_DATA_MODES.ENTIRE_TIME_RANGE,
          ...val
        }))
      },
      extractedIndexPatterns: ['']
    };
    this.visDataSubject = new Rx.BehaviorSubject(undefined);
    this.visData$ = this.visDataSubject.asObservable().pipe((0, _rxjs.share)());
  }
  render() {
    const {
      model,
      visFields
    } = this.state;
    if (!visFields) {
      // wait for fields initialization
      return null;
    }
    const tsvbEditorStyles = (0, _react2.css)`
      overflow-y: auto;
      overflow-x: hidden;
      flex: 1;
    `;
    return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        appName: APP_NAME,
        storage: this.localStorage,
        unifiedSearch: (0, _services.getUnifiedSearchStart)(),
        data: (0, _services.getDataStart)(),
        ...(0, _services.getCoreStart)()
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: tsvbEditorStyles,
      "data-test-subj": "tvbVisEditor",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 198,
        columnNumber: 9
      }
    }, !this.props.vis.params.use_kibana_indexes && /*#__PURE__*/_react.default.createElement(_use_index_patter_mode_callout.UseIndexPatternModeCallout, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 57
      }
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbEditor--hideForReporting",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_vis_picker.VisPicker, {
      currentVisType: model.type,
      onChange: this.handleChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 201,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_vis_editor_visualization.VisEditorVisualization, {
      dirty: this.state.dirty,
      autoApply: this.state.autoApply,
      model: model,
      embeddableHandler: this.props.embeddableHandler,
      eventEmitter: this.props.eventEmitter,
      vis: this.props.vis,
      timeRange: this.props.timeRange,
      filters: this.props.filters,
      query: this.props.query,
      uiState: this.props.uiState,
      onCommit: this.handleCommit,
      onToggleAutoApply: this.handleAutoApplyToggle,
      title: this.props.vis.title,
      description: this.props.vis.description,
      onDataChange: this.onDataChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbEditor--hideForReporting",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_panel_config.PanelConfig, {
      fields: visFields,
      model: model,
      visData$: this.visData$,
      onChange: this.handleChange,
      getConfig: this.getConfig,
      defaultIndexPattern: this.props.defaultIndexPattern,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 13
      }
    }))));
  }
  async componentDidMount() {
    const indexPatterns = (0, _index_patterns_utils.extractIndexPatternValues)(this.props.vis.params, this.getDefaultIndex());
    const visFields = await (0, _fetch_fields.fetchFields)(indexPatterns);
    this.setState({
      visFields
    });
    this.props.eventEmitter.on('updateEditor', this.updateModel);
  }
  componentWillUnmount() {
    var _this$abortController2;
    this.updateVisState.cancel();
    (_this$abortController2 = this.abortControllerFetchFields) === null || _this$abortController2 === void 0 ? void 0 : _this$abortController2.abort();
    this.props.eventEmitter.off('updateEditor', this.updateModel);
  }
  getDefaultIndex() {
    var _this$props$config$ge;
    return (_this$props$config$ge = this.props.config.get('defaultIndex')) !== null && _this$props$config$ge !== void 0 ? _this$props$config$ge : '';
  }
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
exports.default = exports.VisEditor = VisEditor;