"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesConfigQueryBarWithIgnoreGlobalFilter = SeriesConfigQueryBarWithIgnoreGlobalFilter;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _yes_no = require("./yes_no");
var _get_default_query_language = require("./lib/get_default_query_language");
var _query_bar_wrapper = require("./query_bar_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/series_config_query_bar_with_ignore_global_filter.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function SeriesConfigQueryBarWithIgnoreGlobalFilter({
  panel,
  model,
  onChange,
  indexPatternForQuery
}) {
  const htmlId = (0, _eui.htmlIdGenerator)();
  const yesNoOption = /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
    disabled: panel.ignore_global_filter,
    value: model.ignore_global_filter,
    name: "ignore_global_filter",
    onChange: onChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    margin: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('filterInput'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.seriesConfig.filterLabel",
      defaultMessage: "Filter",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 13
      }
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_query_bar_wrapper.QueryBarWrapper, {
    query: {
      language: model.filter && model.filter.language ? model.filter.language : (0, _get_default_query_language.getDefaultQueryLanguage)(),
      query: model.filter && model.filter.query ? model.filter.query : ''
    },
    onChange: filter => onChange({
      filter
    }),
    indexPatterns: [indexPatternForQuery],
    "data-test-subj": "seriesConfigQueryBar",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('seriesIgnoreGlobalFilter'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.seriesConfig.ignoreGlobalFilterLabel",
      defaultMessage: "Ignore global filter?",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 13
      }
    }),
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, panel.ignore_global_filter ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.seriesConfig.ignoreGlobalFilterDisabledTooltip",
      defaultMessage: "This is disabled because the global filters are being ignored in the panel options.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 17
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }, yesNoOption) : yesNoOption)));
}
SeriesConfigQueryBarWithIgnoreGlobalFilter.propTypes = {
  onChange: _propTypes.default.func,
  model: _propTypes.default.object,
  panel: _propTypes.default.object,
  indexPatternForQuery: _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string])
};