"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryBarWrapper = QueryBarWrapper;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/unified-search-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _services = require("../../services");
var _index_patterns_utils = require("../../../common/index_patterns_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/query_bar_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function QueryBarWrapper({
  query,
  onChange,
  isInvalid,
  indexPatterns,
  'data-test-subj': dataTestSubj
}) {
  const dataViews = (0, _services.getDataViewsStart)();
  const [indexes, setIndexes] = (0, _react.useState)([]);
  const kibana = (0, _public2.useKibana)();
  const {
    appName,
    unifiedSearch,
    storage,
    data,
    notifications,
    http,
    docLinks,
    uiSettings,
    usageCollection
  } = kibana.services;
  (0, _react.useEffect)(() => {
    async function fetchIndexes() {
      const i = [];
      for (const index of indexPatterns !== null && indexPatterns !== void 0 ? indexPatterns : []) {
        if (index) {
          if ((0, _index_patterns_utils.isStringTypeIndexPattern)(index)) {
            i.push(index);
          } else if (index !== null && index !== void 0 && index.id) {
            const {
              indexPattern
            } = await (0, _index_patterns_utils.fetchIndexPattern)(index, dataViews);
            if (indexPattern) {
              i.push(indexPattern);
            }
          }
        } else {
          const defaultIndex = await dataViews.getDefault();
          if (defaultIndex) {
            i.push(defaultIndex);
          }
        }
      }
      setIndexes(i);
    }
    fetchIndexes();
  }, [indexPatterns, dataViews]);
  return /*#__PURE__*/_react.default.createElement(_public.QueryStringInput, {
    appName: appName,
    deps: {
      unifiedSearch,
      notifications,
      http,
      docLinks,
      uiSettings,
      data,
      dataViews,
      storage,
      usageCollection
    },
    query: query,
    onChange: onChange,
    isInvalid: isInvalid,
    indexPatterns: indexes,
    dataTestSubj: dataTestSubj,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  });
}