"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeseriesPanelConfig = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _series_editor = require("../series_editor");
var _index_pattern = require("../index_pattern");
var _annotations_editor = require("../annotations_editor");
var _create_select_handler = require("../lib/create_select_handler");
var _color_picker = require("../color_picker");
var _yes_no = require("../yes_no");
var _get_default_query_language = require("../lib/get_default_query_language");
var _query_bar_wrapper = require("../query_bar_wrapper");
var _types = require("./types");
var _enums = require("../../../../common/enums");
var _panel_config = require("./_panel_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/panel_config/timeseries.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const positionOptions = [{
  label: _i18n.i18n.translate('visTypeTimeseries.timeseries.positionOptions.rightLabel', {
    defaultMessage: 'Right'
  }),
  value: 'right'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.timeseries.positionOptions.leftLabel', {
    defaultMessage: 'Left'
  }),
  value: 'left'
}];
const tooltipModeOptions = [{
  label: _i18n.i18n.translate('visTypeTimeseries.timeseries.tooltipOptions.showAll', {
    defaultMessage: 'Show all values'
  }),
  value: 'show_all'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.timeseries.tooltipOptions.showFocused', {
    defaultMessage: 'Show focused values'
  }),
  value: 'show_focused'
}];
const scaleOptions = [{
  label: _i18n.i18n.translate('visTypeTimeseries.timeseries.scaleOptions.normalLabel', {
    defaultMessage: 'Normal'
  }),
  value: 'normal'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.timeseries.scaleOptions.logLabel', {
    defaultMessage: 'Log'
  }),
  value: 'log'
}];
const legendPositionOptions = [{
  label: _i18n.i18n.translate('visTypeTimeseries.timeseries.legendPositionOptions.rightLabel', {
    defaultMessage: 'Right'
  }),
  value: 'right'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.timeseries.legendPositionOptions.leftLabel', {
    defaultMessage: 'Left'
  }),
  value: 'left'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.timeseries.legendPositionOptions.bottomLabel', {
    defaultMessage: 'Bottom'
  }),
  value: 'bottom'
}];
const MAX_TRUNCATE_LINES = 5;
const MIN_TRUNCATE_LINES = 1;
class TimeseriesPanelConfig extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "handleTextChange", name => e => this.props.onChange({
      [name]: e.target.value
    }));
    this.state = {
      selectedTab: _types.PANEL_CONFIG_TABS.DATA
    };
  }
  switchTab(selectedTab) {
    this.setState({
      selectedTab
    });
  }
  render() {
    const defaults = {
      filter: {
        query: '',
        language: (0, _get_default_query_language.getDefaultQueryLanguage)()
      },
      axis_max: '',
      axis_min: '',
      legend_position: 'right',
      show_grid: 1,
      tooltip_mode: _enums.TOOLTIP_MODES.SHOW_ALL,
      ignore_daylight_time: false
    };
    const model = {
      ...defaults,
      ...this.props.model
    };
    const {
      selectedTab
    } = this.state;
    const handleSelectChange = (0, _create_select_handler.createSelectHandler)(this.props.onChange);
    const htmlId = (0, _eui.htmlIdGenerator)();
    const selectedPositionOption = positionOptions.find(option => model.axis_position === option.value);
    const selectedAxisScaleOption = scaleOptions.find(option => model.axis_scale === option.value);
    const selectedLegendPosOption = legendPositionOptions.find(option => model.legend_position === option.value);
    const selectedTooltipMode = tooltipModeOptions.find(option => model.tooltip_mode === option.value);
    const tooltipModeId = htmlId('tooltipMode');
    const tooltipModeLabelId = `${tooltipModeId}Label`;
    const legendPositionId = htmlId('legendPos');
    const legendPositionLabelId = `${legendPositionId}Label`;
    let view;
    if (selectedTab === _types.PANEL_CONFIG_TABS.DATA) {
      view = /*#__PURE__*/_react.default.createElement(_series_editor.SeriesEditor, {
        fields: this.props.fields,
        model: this.props.model,
        onChange: this.props.onChange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 9
        }
      });
    } else if (selectedTab === _types.PANEL_CONFIG_TABS.ANNOTATIONS) {
      view = /*#__PURE__*/_react.default.createElement(_annotations_editor.AnnotationsEditor, {
        fields: this.props.fields,
        model: this.props.model,
        onChange: this.props.onChange,
        defaultIndexPattern: this.props.defaultIndexPattern,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 9
        }
      });
    } else {
      var _model$filter, _model$filter2, _model$axis_min, _model$axis_max;
      view = /*#__PURE__*/_react.default.createElement("div", {
        className: "tvbPanelConfig__container",
        css: _panel_config.panelConfigContainerStyles,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeseries.optionsTab.dataLabel",
        defaultMessage: "Data",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 17
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 190,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_index_pattern.IndexPattern, {
        fields: this.props.fields,
        model: this.props.model,
        onChange: this.props.onChange,
        allowLevelOfDetail: true,
        allowIndexSwitchingMode: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 192,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        wrap: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 201,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 202,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        id: htmlId('panelFilter'),
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "visTypeTimeseries.timeseries.optionsTab.panelFilterLabel",
          defaultMessage: "Panel filter",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 206,
            columnNumber: 21
          }
        }),
        fullWidth: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_query_bar_wrapper.QueryBarWrapper, {
        query: {
          language: ((_model$filter = model.filter) === null || _model$filter === void 0 ? void 0 : _model$filter.language) || (0, _get_default_query_language.getDefaultQueryLanguage)(),
          query: ((_model$filter2 = model.filter) === null || _model$filter2 === void 0 ? void 0 : _model$filter2.query) || ''
        },
        onChange: filter => {
          this.props.onChange({
            filter
          });
        },
        indexPatterns: [model.index_pattern],
        "data-test-subj": "panelFilterQueryBar",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 19
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 226,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: _i18n.i18n.translate('visTypeTimeseries.timeseries.optionsTab.ignoreGlobalFilterLabel', {
          defaultMessage: 'Ignore global filter?'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 227,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
        value: model.ignore_global_filter,
        name: "ignore_global_filter",
        onChange: this.props.onChange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 235,
          columnNumber: 19
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 242,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: _i18n.i18n.translate('visTypeTimeseries.timeseries.optionsTab.ignoreDaylightTimeLabel', {
          defaultMessage: 'Ignore daylight time?'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 243,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
        value: model.ignore_daylight_time,
        name: "ignore_daylight_time",
        onChange: this.props.onChange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 251,
          columnNumber: 19
        }
      }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 261,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 263,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 264,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 265,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeseries.optionsTab.styleLabel",
        defaultMessage: "Style",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 266,
          columnNumber: 17
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 272,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        wrap: true,
        alignItems: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 274,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 275,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        id: htmlId('axisMin'),
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "visTypeTimeseries.timeseries.optionsTab.axisMinLabel",
          defaultMessage: "Axis min",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 279,
            columnNumber: 21
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 276,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        onChange: this.handleTextChange('axis_min'),
        value: (_model$axis_min = model.axis_min) !== null && _model$axis_min !== void 0 ? _model$axis_min : '',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 285,
          columnNumber: 19
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 291,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        id: htmlId('axisMax'),
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "visTypeTimeseries.timeseries.optionsTab.axisMaxLabel",
          defaultMessage: "Axis max",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 295,
            columnNumber: 21
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 292,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        onChange: this.handleTextChange('axis_max'),
        value: (_model$axis_max = model.axis_max) !== null && _model$axis_max !== void 0 ? _model$axis_max : '',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 301,
          columnNumber: 19
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 307,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        id: htmlId('axisPos'),
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "visTypeTimeseries.timeseries.optionsTab.axisPositionLabel",
          defaultMessage: "Axis position",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 311,
            columnNumber: 21
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 308,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        isClearable: false,
        options: positionOptions,
        selectedOptions: selectedPositionOption ? [selectedPositionOption] : [],
        onChange: handleSelectChange('axis_position'),
        singleSelection: {
          asPlainText: true
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 317,
          columnNumber: 19
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 326,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        id: htmlId('axisScale'),
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "visTypeTimeseries.timeseries.optionsTab.axisScaleLabel",
          defaultMessage: "Axis scale",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 330,
            columnNumber: 21
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 327,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        isClearable: false,
        options: scaleOptions,
        selectedOptions: selectedAxisScaleOption ? [selectedAxisScaleOption] : [],
        onChange: handleSelectChange('axis_scale'),
        singleSelection: {
          asPlainText: true
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 336,
          columnNumber: 19
        }
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 347,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        wrap: true,
        alignItems: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 349,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 350,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 351,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeseries.optionsTab.backgroundColorLabel",
        defaultMessage: "Background color:",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 352,
          columnNumber: 19
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 358,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_color_picker.ColorPicker, {
        onChange: this.props.onChange,
        name: "background_color",
        value: model.background_color,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 359,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 365,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 366,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeseries.optionsTab.displayGridLabel",
        defaultMessage: "Display grid",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 367,
          columnNumber: 19
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 373,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
        value: model.show_grid,
        name: "show_grid",
        onChange: this.props.onChange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 374,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 376,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
        id: tooltipModeLabelId,
        htmlFor: tooltipModeId,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 377,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeseries.optionsTab.tooltipMode",
        defaultMessage: "Tooltip",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 378,
          columnNumber: 19
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 384,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        isClearable: false,
        id: tooltipModeId,
        "aria-labelledby": tooltipModeLabelId,
        options: tooltipModeOptions,
        selectedOptions: selectedTooltipMode ? [selectedTooltipMode] : [],
        onChange: handleSelectChange('tooltip_mode'),
        singleSelection: {
          asPlainText: true
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 385,
          columnNumber: 17
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        wrap: true,
        alignItems: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 396,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 397,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 398,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeseries.optionsTab.showLegendLabel",
        defaultMessage: "Show legend?",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 399,
          columnNumber: 19
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 405,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
        value: model.show_legend,
        name: "show_legend",
        onChange: this.props.onChange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 406,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 412,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 413,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeseries.optionsTab.truncateLegendLabel",
        defaultMessage: "Truncate legend?",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 414,
          columnNumber: 19
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 420,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
        value: model.truncate_legend,
        name: "truncate_legend",
        onChange: this.props.onChange,
        "data-test-subj": "timeSeriesEditorDataTruncateLegendSwitch",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 421,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 428,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 429,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeseries.optionsTab.maxLinesLabel",
        defaultMessage: "Maximum legend lines",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 430,
          columnNumber: 19
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 436,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
        "data-test-subj": "timeSeriesEditorDataMaxLegendLines",
        value: model.max_lines_legend,
        min: MIN_TRUNCATE_LINES,
        max: MAX_TRUNCATE_LINES,
        compressed: true,
        disabled: !Boolean(model.truncate_legend),
        onChange: e => {
          const val = Number(e.target.value);
          this.props.onChange({
            max_lines_legend: Math.min(MAX_TRUNCATE_LINES, Math.max(val, MIN_TRUNCATE_LINES))
          });
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 437,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 455,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
        id: legendPositionLabelId,
        htmlFor: legendPositionId,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 456,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.timeseries.optionsTab.legendPositionLabel",
        defaultMessage: "Legend position",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 457,
          columnNumber: 19
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 463,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
        isClearable: false,
        id: legendPositionId,
        "aria-labelledby": legendPositionLabelId,
        options: legendPositionOptions,
        selectedOptions: selectedLegendPosOption ? [selectedLegendPosOption] : [],
        onChange: handleSelectChange('legend_position'),
        singleSelection: {
          asPlainText: true
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 464,
          columnNumber: 17
        }
      })))));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 481,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: selectedTab === _types.PANEL_CONFIG_TABS.DATA,
      onClick: () => this.switchTab(_types.PANEL_CONFIG_TABS.DATA),
      "data-test-subj": "timeSeriesEditorDataBtn",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 482,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.timeseries.dataTab.dataButtonLabel",
      defaultMessage: "Data",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 487,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: selectedTab === _types.PANEL_CONFIG_TABS.OPTIONS,
      onClick: () => this.switchTab(_types.PANEL_CONFIG_TABS.OPTIONS),
      "data-test-subj": "timeSeriesEditorPanelOptionsBtn",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 492,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.timeseries.optionsTab.panelOptionsButtonLabel",
      defaultMessage: "Panel options",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 497,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: selectedTab === _types.PANEL_CONFIG_TABS.ANNOTATIONS,
      onClick: () => this.switchTab(_types.PANEL_CONFIG_TABS.ANNOTATIONS),
      "data-test-subj": "timeSeriesEditorAnnotationsBtn",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 502,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.timeseries.annotationsTab.annotationsButtonLabel",
      defaultMessage: "Annotations",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 507,
        columnNumber: 13
      }
    }))), view);
  }
}
exports.TimeseriesPanelConfig = TimeseriesPanelConfig;