"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TablePanelConfig = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _field_select = require("../aggs/field_select");
var _series_editor = require("../series_editor");
var _index_pattern = require("../index_pattern");
var _yes_no = require("../yes_no");
var _query_bar_wrapper = require("../query_bar_wrapper");
var _get_default_query_language = require("../lib/get_default_query_language");
var _vis_data_context = require("../../contexts/vis_data_context");
var _enums = require("../../../../common/enums");
var _types = require("./types");
var _index_patterns_utils = require("../../../../common/index_patterns_utils");
var _panel_config = require("./_panel_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/panel_config/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class TablePanelConfig extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "handlePivotChange", selectedOptions => {
      const {
        fields,
        model
      } = this.props;
      const getPivotType = fieldName => {
        const field = fields[(0, _index_patterns_utils.getIndexPatternKey)(model.index_pattern)].find(f => f.name === fieldName);
        return (0, _lodash.get)(field, 'type', null);
      };
      this.props.onChange(selectedOptions.length === 1 ? {
        pivot_id: selectedOptions[0] || undefined,
        pivot_type: getPivotType(selectedOptions[0]) || undefined
      } : {
        pivot_id: selectedOptions,
        pivot_type: selectedOptions.map(item => getPivotType(item))
      });
    });
    (0, _defineProperty2.default)(this, "handleTextChange", name => e => this.props.onChange({
      [name]: e.target.value
    }));
    (0, _defineProperty2.default)(this, "handleNumberChange", name => e => this.props.onChange({
      [name]: !e.target.value ? undefined : Number(e.target.value)
    }));
    this.state = {
      selectedTab: _types.PANEL_CONFIG_TABS.DATA
    };
  }
  UNSAFE_componentWillMount() {
    const {
      model
    } = this.props;
    if (!model.bar_color_rules || !model.bar_color_rules.length) {
      this.props.onChange({
        bar_color_rules: [{
          id: (0, _uuid.v4)()
        }]
      });
    }
  }
  switchTab(selectedTab) {
    this.setState({
      selectedTab
    });
  }
  render() {
    var _model$pivot_label, _model$drilldown_url, _model$filter, _model$filter2;
    const {
      selectedTab
    } = this.state;
    const defaults = {
      drilldown_url: '',
      filter: {
        query: '',
        language: (0, _get_default_query_language.getDefaultQueryLanguage)()
      },
      pivot_label: '',
      pivot_type: ''
    };
    const model = {
      ...defaults,
      ...this.props.model
    };
    const htmlId = (0, _eui.htmlIdGenerator)();
    const view = selectedTab === _types.PANEL_CONFIG_TABS.DATA ? /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbPanelConfig__container",
      css: _panel_config.panelConfigContainerStyles,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.table.dataTab.defineFieldDescription",
      defaultMessage: "For the table visualization you need to define a field to group by using a terms aggregation.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": "groupByField",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.table.dataTab.groupByFieldLabel",
        defaultMessage: "Group by field",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 23
        }
      }),
      restrict: [_public.KBN_FIELD_TYPES.NUMBER, _public.KBN_FIELD_TYPES.BOOLEAN, _public.KBN_FIELD_TYPES.DATE, _public.KBN_FIELD_TYPES.IP, _public.KBN_FIELD_TYPES.STRING],
      fields: this.props.fields,
      value: model.pivot_id,
      indexPattern: model.index_pattern,
      onChange: this.handlePivotChange,
      uiRestrictions: this.context.uiRestrictions,
      type: _enums.BUCKET_TYPES.TERMS,
      allowMultiSelect: true,
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('pivotLabelInput'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.table.dataTab.columnLabel",
        defaultMessage: "Column label",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 161,
          columnNumber: 23
        }
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": "columnLabelName",
      onChange: this.handleTextChange('pivot_label'),
      value: (_model$pivot_label = model.pivot_label) !== null && _model$pivot_label !== void 0 ? _model$pivot_label : '',
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('pivotRowsInput'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.table.dataTab.rowsLabel",
        defaultMessage: "Rows",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 23
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      onChange: this.handleNumberChange('pivot_rows'),
      value: model.pivot_rows !== undefined ? Number(model.pivot_rows) : '',
      placeholder: "10",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 21
      }
    })))))), /*#__PURE__*/_react.default.createElement(_series_editor.SeriesEditor, {
      fields: this.props.fields,
      model: this.props.model,
      onChange: this.props.onChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 11
      }
    })) : /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbPanelConfig__container",
      css: _panel_config.panelConfigContainerStyles,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.table.optionsTab.dataLabel",
      defaultMessage: "Data",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('drilldownInput'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.table.optionsTab.itemUrlLabel",
        defaultMessage: "Item url",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 218,
          columnNumber: 17
        }
      }),
      helpText: /*#__PURE__*/_react.default.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 224,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.table.optionsTab.itemUrlHelpText",
        defaultMessage: "This supports mustache templating. {key} is set to the term.",
        values: {
          key: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 228,
              columnNumber: 36
            }
          }, '{{key}}')
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 225,
          columnNumber: 19
        }
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      onChange: this.handleTextChange('drilldown_url'),
      value: (_model$drilldown_url = model.drilldown_url) !== null && _model$drilldown_url !== void 0 ? _model$drilldown_url : '',
      "data-test-subj": "drilldownUrl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_index_pattern.IndexPattern, {
      fields: this.props.fields,
      model: this.props.model,
      onChange: this.props.onChange,
      allowIndexSwitchingMode: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('panelFilterInput'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.table.optionsTab.panelFilterLabel",
        defaultMessage: "Panel filter",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 256,
          columnNumber: 21
        }
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_query_bar_wrapper.QueryBarWrapper, {
      query: {
        language: ((_model$filter = model.filter) === null || _model$filter === void 0 ? void 0 : _model$filter.language) || (0, _get_default_query_language.getDefaultQueryLanguage)(),
        query: ((_model$filter2 = model.filter) === null || _model$filter2 === void 0 ? void 0 : _model$filter2.query) || ''
      },
      onChange: filter => {
        this.props.onChange({
          filter
        });
      },
      indexPatterns: [model.index_pattern],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 275,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('visTypeTimeseries.table.optionsTab.ignoreGlobalFilterLabel', {
        defaultMessage: 'Ignore global filter?'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
      value: model.ignore_global_filter,
      name: "ignore_global_filter",
      onChange: this.props.onChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 284,
        columnNumber: 19
      }
    }))))));
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: selectedTab === _types.PANEL_CONFIG_TABS.DATA,
      onClick: () => this.switchTab(_types.PANEL_CONFIG_TABS.DATA),
      "data-test-subj": "tableEditorDataBtn",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.table.dataTab.columnsButtonLabel",
      defaultMessage: "Columns",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: selectedTab === _types.PANEL_CONFIG_TABS.OPTIONS,
      onClick: () => this.switchTab(_types.PANEL_CONFIG_TABS.OPTIONS),
      "data-test-subj": "tableEditorPanelOptionsBtn",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 309,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.table.optionsTab.panelOptionsButtonLabel",
      defaultMessage: "Panel options",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 314,
        columnNumber: 13
      }
    }))), view);
  }
}
exports.TablePanelConfig = TablePanelConfig;
(0, _defineProperty2.default)(TablePanelConfig, "contextType", _vis_data_context.VisDataContext);