"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GaugePanelConfig = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _series_editor = require("../series_editor");
var _index_pattern = require("../index_pattern");
var _create_select_handler = require("../lib/create_select_handler");
var _color_rules = require("../color_rules");
var _color_picker = require("../color_picker");
var _query_bar_wrapper = require("../query_bar_wrapper");
var _get_default_query_language = require("../lib/get_default_query_language");
var _yes_no = require("../yes_no");
var _ui_restrictions = require("../../../../common/ui_restrictions");
var _enums = require("../../../../common/enums");
var _types = require("./types");
var _panel_config = require("./_panel_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/panel_config/gauge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// @ts-ignore
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class GaugePanelConfig extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "handleTextChange", name => e => this.props.onChange({
      [name]: e.target.value
    }));
    this.state = {
      selectedTab: _types.PANEL_CONFIG_TABS.DATA
    };
  }
  UNSAFE_componentWillMount() {
    const {
      model
    } = this.props;
    const parts = {};
    if (!model.gauge_color_rules || !model.gauge_color_rules.length) {
      parts.gauge_color_rules = [{
        id: (0, _uuid.v4)()
      }];
    }
    if (model.gauge_width == null) parts.gauge_width = 10;
    if (model.gauge_inner_width == null) parts.gauge_inner_width = 10;
    if (model.gauge_style == null) parts.gauge_style = 'half';
    this.props.onChange(parts);
  }
  switchTab(selectedTab) {
    this.setState({
      selectedTab
    });
  }
  render() {
    var _model$filter, _model$filter2;
    const {
      selectedTab
    } = this.state;
    const defaults = {
      gauge_max: '',
      filter: {
        query: '',
        language: (0, _get_default_query_language.getDefaultQueryLanguage)()
      },
      gauge_style: 'circle',
      gauge_inner_width: '',
      gauge_width: ''
    };
    const model = {
      ...defaults,
      ...this.props.model
    };
    const handleSelectChange = (0, _create_select_handler.createSelectHandler)(this.props.onChange);
    const styleOptions = [{
      label: _i18n.i18n.translate('visTypeTimeseries.gauge.styleOptions.circleLabel', {
        defaultMessage: 'Circle'
      }),
      value: 'circle'
    }, {
      label: _i18n.i18n.translate('visTypeTimeseries.gauge.styleOptions.halfCircleLabel', {
        defaultMessage: 'Half Circle'
      }),
      value: 'half'
    }];
    const htmlId = (0, _eui.htmlIdGenerator)();
    const selectedGaugeStyleOption = styleOptions.find(option => model.gauge_style === option.value);
    const view = selectedTab === _types.PANEL_CONFIG_TABS.DATA ? /*#__PURE__*/_react.default.createElement(_series_editor.SeriesEditor, {
      colorPicker: true,
      fields: this.props.fields,
      limit: _ui_restrictions.limitOfSeries[_enums.PANEL_TYPES.GAUGE],
      model: this.props.model,
      onChange: this.props.onChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 9
      }
    }) : /*#__PURE__*/_react.default.createElement("div", {
      className: "tvbPanelConfig__container",
      css: _panel_config.panelConfigContainerStyles,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.gauge.optionsTab.dataLabel",
      defaultMessage: "Data",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_index_pattern.IndexPattern, {
      fields: this.props.fields,
      model: this.props.model,
      onChange: this.props.onChange,
      allowIndexSwitchingMode: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('panelFilter'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.gauge.optionsTab.panelFilterLabel",
        defaultMessage: "Panel filter",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 21
        }
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_query_bar_wrapper.QueryBarWrapper, {
      query: {
        language: ((_model$filter = model.filter) === null || _model$filter === void 0 ? void 0 : _model$filter.language) || (0, _get_default_query_language.getDefaultQueryLanguage)(),
        query: ((_model$filter2 = model.filter) === null || _model$filter2 === void 0 ? void 0 : _model$filter2.query) || ''
      },
      onChange: filter => {
        this.props.onChange({
          filter
        });
      },
      indexPatterns: [model.index_pattern],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('visTypeTimeseries.gauge.optionsTab.ignoreGlobalFilterLabel', {
        defaultMessage: 'Ignore global filter?'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_yes_no.YesNo, {
      value: model.ignore_global_filter,
      name: "ignore_global_filter",
      onChange: this.props.onChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 19
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.gauge.optionsTab.styleLabel",
      defaultMessage: "Style",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      wrap: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('gaugeMax'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.gauge.optionsTab.gaugeMaxLabel",
        defaultMessage: "Gauge max (empty for auto)",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 21
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      onChange: this.handleTextChange('gauge_max'),
      value: model.gauge_max,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('gaugeStyle'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.gauge.optionsTab.gaugeStyleLabel",
        defaultMessage: "Gauge style",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 215,
          columnNumber: 21
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      isClearable: false,
      options: styleOptions,
      selectedOptions: selectedGaugeStyleOption ? [selectedGaugeStyleOption] : [],
      onChange: handleSelectChange('gauge_style'),
      singleSelection: {
        asPlainText: true
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('innerLine'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.gauge.optionsTab.innerLineWidthLabel",
        defaultMessage: "Inner line width",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 234,
          columnNumber: 21
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      onChange: this.handleTextChange('gauge_inner_width'),
      value: Number(model.gauge_inner_width),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: htmlId('gaugeLine'),
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.gauge.optionsTab.gaugeLineWidthLabel",
        defaultMessage: "Gauge line width",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 250,
          columnNumber: 21
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      onChange: this.handleTextChange('gauge_width'),
      value: Number(model.gauge_width),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 256,
        columnNumber: 19
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      wrap: true,
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 266,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 267,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.gauge.optionsTab.backgroundColorLabel",
      defaultMessage: "Background color:",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 275,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_color_picker.ColorPicker, {
      onChange: this.props.onChange,
      name: "background_color",
      value: model.background_color,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 276,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 282,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 283,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.gauge.optionsTab.innerColorLabel",
      defaultMessage: "Inner color:",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 284,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 290,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_color_picker.ColorPicker, {
      onChange: this.props.onChange,
      name: "gauge_inner_color",
      value: model.gauge_inner_color,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 291,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 301,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 302,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.gauge.optionsTab.colorRulesLabel",
      defaultMessage: "Color rules",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 309,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_color_rules.ColorRules, {
      primaryName: "gauge color",
      primaryVarName: "gauge",
      secondaryName: "text color",
      secondaryVarName: "text",
      model: model,
      onChange: this.props.onChange,
      name: "gauge_color_rules",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 310,
        columnNumber: 13
      }
    })));
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 325,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: selectedTab === _types.PANEL_CONFIG_TABS.DATA,
      onClick: () => this.switchTab(_types.PANEL_CONFIG_TABS.DATA),
      "data-test-subj": "gaugeEditorDataBtn",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 326,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.gauge.dataTab.dataButtonLabel",
      defaultMessage: "Data",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 331,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      isSelected: selectedTab === _types.PANEL_CONFIG_TABS.OPTIONS,
      onClick: () => this.switchTab(_types.PANEL_CONFIG_TABS.OPTIONS),
      "data-test-subj": "gaugeEditorPanelOptionsBtn",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 336,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.gauge.optionsTab.panelOptionsButtonLabel",
      defaultMessage: "Panel options",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 341,
        columnNumber: 13
      }
    }))), view);
  }
}
exports.GaugePanelConfig = GaugePanelConfig;