"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldTextSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _switch_mode_popover = require("./switch_mode_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/lib/index_pattern_select/field_text_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const updateIndexText = _i18n.i18n.translate('visTypeTimeseries.indexPatternSelect.updateIndex', {
  defaultMessage: 'Update visualization with entered data view'
});
const FieldTextSelect = ({
  fetchedIndex,
  onIndexChange,
  disabled,
  placeholder,
  onModeChange,
  allowSwitchMode,
  'data-test-subj': dataTestSubj
}) => {
  const [inputValue, setInputValue] = (0, _react.useState)();
  const {
    indexPatternString
  } = fetchedIndex;
  const onFieldTextChange = (0, _react.useCallback)(e => {
    setInputValue(e.target.value);
  }, []);
  (0, _react.useEffect)(() => {
    if (inputValue === undefined) {
      setInputValue(indexPatternString !== null && indexPatternString !== void 0 ? indexPatternString : '');
    }
  }, [indexPatternString, inputValue]);
  const updateIndex = (0, _react.useCallback)(() => {
    if ((inputValue !== null && inputValue !== void 0 ? inputValue : '') !== (indexPatternString !== null && indexPatternString !== void 0 ? indexPatternString : '')) {
      onIndexChange(inputValue);
    }
  }, [onIndexChange, inputValue, indexPatternString]);
  const appends = [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": updateIndexText,
    iconType: "play",
    onClick: updateIndex,
    disabled: inputValue === indexPatternString,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  })];
  if (allowSwitchMode) {
    appends.push(/*#__PURE__*/_react.default.createElement(_switch_mode_popover.SwitchModePopover, {
      onModeChange: onModeChange,
      fetchedIndex: fetchedIndex,
      useKibanaIndices: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 7
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: disabled,
    onChange: onFieldTextChange,
    value: inputValue !== null && inputValue !== void 0 ? inputValue : '',
    placeholder: placeholder,
    "data-test-subj": dataTestSubj,
    append: appends,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  });
};
exports.FieldTextSelect = FieldTextSelect;