"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalUrlErrorModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/lib/external_url_error_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ExternalUrlErrorModal = ({
  url,
  handleClose
}) => {
  const externalUrlErrorModalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: handleClose,
    "aria-labelledby": externalUrlErrorModalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: externalUrlErrorModalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.externalUrlErrorModal.headerTitle",
    defaultMessage: "Access to this external URL is not yet enabled",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.externalUrlErrorModal.bodyMessage",
    defaultMessage: "Configure {externalUrlPolicy} in your {kibanaConfigFileName} to allow access to {url}.",
    values: {
      url: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "warning",
        component: "span",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 15
        }
      }, url),
      externalUrlPolicy: 'externalUrl.policy',
      kibanaConfigFileName: 'kibana.yml'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: handleClose,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.externalUrlErrorModal.closeButtonLabel",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }))));
};
exports.ExternalUrlErrorModal = ExternalUrlErrorModal;