"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LastValueModePopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/last_value_mode_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LastValueModePopover = ({
  isIndicatorDisplayed,
  toggleIndicatorDisplay
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => setIsPopoverOpen(isOpen => !isOpen), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    className: "tvbLastValueModePopover",
    css: (0, _react2.css)`
        height: auto;
      `,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: 'gear',
      onClick: onButtonClick,
      "aria-label": _i18n.i18n.translate('visTypeTimeseries.lastValueModePopover.gearButton', {
        defaultMessage: 'Change last value indicator display option'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "tvbLastValueModePopoverBody",
    css: (0, _react2.css)`
          width: 360px;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('visTypeTimeseries.lastValueModePopover.title', {
    defaultMessage: 'Last value options'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: isIndicatorDisplayed,
    label: _i18n.i18n.translate('visTypeTimeseries.lastValueModePopover.switch', {
      defaultMessage: 'Show label when using Last value mode'
    }),
    onChange: toggleIndicatorDisplay,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  })));
};
exports.LastValueModePopover = LastValueModePopover;