"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ICONS = void 0;
exports.IconSelect = IconSelect;
exports.IconView = IconView;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _icons = require("../../visualizations/constants/icons");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/icon_select/icon_select.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ICONS = exports.ICONS = [{
  value: 'fa-asterisk',
  label: _i18n.i18n.translate('visTypeTimeseries.iconSelect.asteriskLabel', {
    defaultMessage: 'Asterisk'
  })
}, {
  value: 'fa-bell',
  label: _i18n.i18n.translate('visTypeTimeseries.iconSelect.bellLabel', {
    defaultMessage: 'Bell'
  })
}, {
  value: 'fa-bolt',
  label: _i18n.i18n.translate('visTypeTimeseries.iconSelect.boltLabel', {
    defaultMessage: 'Bolt'
  })
}, {
  value: 'fa-comment',
  label: _i18n.i18n.translate('visTypeTimeseries.iconSelect.commentLabel', {
    defaultMessage: 'Comment'
  })
}, {
  value: 'fa-map-marker',
  label: _i18n.i18n.translate('visTypeTimeseries.iconSelect.mapMarkerLabel', {
    defaultMessage: 'Map Marker'
  })
}, {
  value: 'fa-map-pin',
  label: _i18n.i18n.translate('visTypeTimeseries.iconSelect.mapPinLabel', {
    defaultMessage: 'Map Pin'
  })
}, {
  value: 'fa-star',
  label: _i18n.i18n.translate('visTypeTimeseries.iconSelect.starLabel', {
    defaultMessage: 'Star'
  })
}, {
  value: 'fa-tag',
  label: _i18n.i18n.translate('visTypeTimeseries.iconSelect.tagLabel', {
    defaultMessage: 'Tag'
  })
}, {
  value: 'fa-bomb',
  label: _i18n.i18n.translate('visTypeTimeseries.iconSelect.bombLabel', {
    defaultMessage: 'Bomb'
  })
}, {
  value: 'fa-bug',
  label: _i18n.i18n.translate('visTypeTimeseries.iconSelect.bugLabel', {
    defaultMessage: 'Bug'
  })
}, {
  value: 'fa-exclamation-triangle',
  label: _i18n.i18n.translate('visTypeTimeseries.iconSelect.exclamationTriangleLabel', {
    defaultMessage: 'Exclamation Triangle'
  })
}, {
  value: 'fa-fire',
  label: _i18n.i18n.translate('visTypeTimeseries.iconSelect.fireLabel', {
    defaultMessage: 'Fire'
  })
}, {
  value: 'fa-flag',
  label: _i18n.i18n.translate('visTypeTimeseries.iconSelect.flagLabel', {
    defaultMessage: 'Flag'
  })
}, {
  value: 'fa-heart',
  label: _i18n.i18n.translate('visTypeTimeseries.iconSelect.heartLabel', {
    defaultMessage: 'Heart'
  })
}];
function IconView({
  value: icon,
  label
}) {
  return /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _icons.ICON_TYPES_MAP[icon],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }), ` ${label}`);
}
function IconSelect({
  value,
  onChange
}) {
  const selectedIcon = ICONS.find(option => value === option.value) || ICONS[0];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isClearable: false,
    options: ICONS,
    selectedOptions: [selectedIcon],
    onChange: onChange,
    singleSelection: {
      asPlainText: true
    },
    renderOption: IconView,
    "aria-label": _i18n.i18n.translate('visTypeTimeseries.iconSelect.comboBoxAriaLabel', {
      defaultMessage: 'Icon selection'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  });
}
IconSelect.propTypes = {
  onChange: _propTypes.default.func.isRequired,
  value: _propTypes.default.string.isRequired
};