"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PositiveRateAgg = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _agg_select = require("./agg_select");
var _field_select = require("./field_select");
var _agg_row = require("./agg_row");
var _create_change_handler = require("../lib/create_change_handler");
var _create_select_handler = require("../lib/create_select_handler");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/aggs/positive_rate.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const UNIT_OPTIONS = [{
  label: _i18n.i18n.translate('visTypeTimeseries.units.auto', {
    defaultMessage: 'auto'
  }),
  value: ''
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.units.perMillisecond', {
    defaultMessage: 'per millisecond'
  }),
  value: '1ms'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.units.perSecond', {
    defaultMessage: 'per second'
  }),
  value: '1s'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.units.perMinute', {
    defaultMessage: 'per minute'
  }),
  value: '1m'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.units.perHour', {
    defaultMessage: 'per hour'
  }),
  value: '1h'
}, {
  label: _i18n.i18n.translate('visTypeTimeseries.units.perDay', {
    defaultMessage: 'per day'
  }),
  value: '1d'
}];
const PositiveRateAgg = props => {
  const defaults = {
    unit: ''
  };
  const model = {
    ...defaults,
    ...props.model
  };
  const handleChange = (0, _create_change_handler.createChangeHandler)(props.onChange, model);
  const handleSelectChange = (0, _create_select_handler.createSelectHandler)(handleChange);
  const htmlId = (0, _eui.htmlIdGenerator)();
  const indexPattern = props.series.override_index_pattern ? props.series.series_index_pattern : props.panel.index_pattern;
  const selectedUnitOptions = UNIT_OPTIONS.filter(o => o.value === model.unit);
  return /*#__PURE__*/_react.default.createElement(_agg_row.AggRow, {
    disableDelete: props.disableDelete,
    model: props.model,
    onAdd: props.onAdd,
    onDelete: props.onDelete,
    siblings: props.siblings,
    dragHandleProps: props.dragHandleProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    htmlFor: htmlId('aggregation'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.positiveRate.aggregationLabel",
    defaultMessage: "Aggregation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_agg_select.AggSelect, {
    id: htmlId('aggregation'),
    panelType: props.panel.type,
    siblings: props.siblings,
    value: model.type,
    onChange: handleSelectChange('type'),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_field_select.FieldSelect, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.postiveRate.fieldLabel",
      defaultMessage: "Field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 15
      }
    }),
    fields: props.fields,
    type: model.type,
    restrict: [_public.KBN_FIELD_TYPES.NUMBER],
    indexPattern: indexPattern,
    value: model.field,
    onChange: value => handleChange({
      field: value === null || value === void 0 ? void 0 : value[0]
    }),
    uiRestrictions: props.uiRestrictions,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: htmlId('units'),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.positiveRate.unitsLabel",
      defaultMessage: "Scale",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 15
      }
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: _i18n.i18n.translate('visTypeTimeseries.positiveRate.unitSelectPlaceholder', {
      defaultMessage: 'Select scale...'
    }),
    options: UNIT_OPTIONS,
    onChange: handleSelectChange('unit'),
    singleSelection: {
      asPlainText: true
    },
    selectedOptions: selectedUnitOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visTypeTimeseries.positiveRate.helpText",
    defaultMessage: "This aggregation should only be applied to {link}, it is a shortcut for applying max, derivative and positive only to a field.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://en.wikipedia.org/wiki/Monotonic_function",
        target: "_BLANK",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "visTypeTimeseries.positiveRate.helpTextLink",
        defaultMessage: "monotonically increasing numbers",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 156,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }))));
};
exports.PositiveRateAgg = PositiveRateAgg;
PositiveRateAgg.propTypes = {
  disableDelete: _propTypes.default.bool,
  fields: _propTypes.default.object,
  model: _propTypes.default.object,
  onAdd: _propTypes.default.func,
  onChange: _propTypes.default.func,
  onDelete: _propTypes.default.func,
  panel: _propTypes.default.object,
  series: _propTypes.default.object,
  siblings: _propTypes.default.array
};