"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricSelect = MetricSelect;
exports.filterRows = filterRows;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _calculate_siblings = require("../lib/calculate_siblings");
var _calculate_label = require("../../../../common/calculate_label");
var _basic_aggs = require("../../../../common/basic_aggs");
var _to_percentile_number = require("../../../../common/to_percentile_number");
var _enums = require("../../../../common/enums");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/aggs/metric_select.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function createTypeFilter(restrict, exclude = []) {
  return metric => {
    if (exclude.includes(metric.type)) {
      return false;
    }
    switch (restrict) {
      case 'basic':
        return _basic_aggs.basicAggs.includes(metric.type);
      default:
        return true;
    }
  };
}

// This filters out sibling aggs, percentiles, and special aggs (like Series Agg)
function filterRows(includeSiblings) {
  return row => {
    if (includeSiblings) {
      return !/^series/.test(row.type) && !/^percentile/.test(row.type) && row.type !== 'math';
    }
    return !/_bucket$/.test(row.type) && !/^series/.test(row.type) && !/^percentile/.test(row.type) && row.type !== 'math';
  };
}
function MetricSelect(props) {
  const {
    additionalOptions,
    restrict,
    metric,
    fields,
    metrics,
    onChange,
    value,
    exclude,
    includeSiblings,
    clearable,
    ...rest
  } = props;
  const calculatedMetrics = metrics.filter(createTypeFilter(restrict, exclude));
  const siblings = (0, _calculate_siblings.calculateSiblings)(calculatedMetrics, metric);

  // Percentiles need to be handled differently because one percentile aggregation
  // could have multiple percentiles associated with it. So the user needs a way
  // to specify which percentile the want to use.
  const percentileOptions = siblings.filter(row => /^percentile/.test(row.type)).reduce((acc, row) => {
    const label = (0, _calculate_label.calculateLabel)(row, calculatedMetrics, fields, false);
    switch (row.type) {
      case _enums.TSVB_METRIC_TYPES.PERCENTILE_RANK:
        (row.values || []).forEach(p => {
          const value = (0, _to_percentile_number.toPercentileNumber)(p);
          acc.push({
            value: `${row.id}[${value}]`,
            label: `${label} (${value})`
          });
        });
      case _enums.TSVB_METRIC_TYPES.PERCENTILE:
        (row.percentiles || []).forEach(p => {
          if (p.value) {
            const value = (0, _to_percentile_number.toPercentileNumber)(p.value);
            acc.push({
              value: `${row.id}[${value}]`,
              label: `${label} (${value})`
            });
          }
        });
    }
    return acc;
  }, []);
  const options = siblings.filter(filterRows(includeSiblings)).map(row => {
    const label = (0, _calculate_label.calculateLabel)(row, calculatedMetrics, fields, false);
    return {
      value: row.id,
      label
    };
  });
  const allOptions = [...options, ...additionalOptions, ...percentileOptions];
  const selectedOption = allOptions.find(option => {
    return value === option.value;
  });
  const selectedOptions = selectedOption ? [selectedOption] : [];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    placeholder: _i18n.i18n.translate('visTypeTimeseries.metricSelect.selectMetricPlaceholder', {
      defaultMessage: 'Select metric…'
    }),
    options: allOptions,
    selectedOptions: selectedOptions,
    onChange: onChange,
    singleSelection: {
      asPlainText: true
    },
    isClearable: clearable
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }));
}
MetricSelect.defaultProps = {
  additionalOptions: [],
  exclude: [],
  metric: {},
  restrict: 'none',
  includeSiblings: false
};
MetricSelect.propTypes = {
  additionalOptions: _propTypes.default.array,
  exclude: _propTypes.default.array,
  metric: _propTypes.default.object,
  onChange: _propTypes.default.func,
  restrict: _propTypes.default.string,
  value: _propTypes.default.string,
  includeSiblings: _propTypes.default.bool
};