"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Agg = Agg;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _agg_to_component = require("../lib/agg_to_component");
var _check_ui_restrictions = require("../../../../common/check_ui_restrictions");
var _invalid_agg = require("./invalid_agg");
var _series_change_handler = require("../lib/series_change_handler");
var _check_if_numeric_metric = require("../lib/check_if_numeric_metric");
var _get_formatter_type = require("../lib/get_formatter_type");
var _enums = require("../../../../common/enums");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/aggs/agg.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// @ts-ignore
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Agg(props) {
  const {
    model,
    uiRestrictions,
    series,
    name,
    onModelChange,
    fields,
    siblings
  } = props;
  const type = model.type;
  let Component = _agg_to_component.aggToComponent[type];
  if (!Component) {
    Component = (0, _invalid_agg.getInvalidAggComponent)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.agg.aggIsNotSupportedDescription",
      defaultMessage: "The {modelType} aggregation is no longer supported.",
      values: {
        modelType: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 53,
            columnNumber: 30
          }
        }, props.model.type)
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 7
      }
    }));
  } else if (!(0, _check_ui_restrictions.isMetricEnabled)(model.type, uiRestrictions)) {
    Component = (0, _invalid_agg.getInvalidAggComponent)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visTypeTimeseries.agg.aggIsUnsupportedForPanelConfigDescription",
      defaultMessage: "The {modelType} aggregation is not supported for existing panel configuration.",
      values: {
        modelType: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 61,
            columnNumber: 30
          }
        }, props.model.type)
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 7
      }
    }));
  }
  const style = {
    cursor: 'default',
    ...props.style
  };
  const indexPattern = props.series.override_index_pattern ? props.series.series_index_pattern : props.panel.index_pattern;
  const isKibanaIndexPattern = props.panel.use_kibana_indexes || indexPattern === '';
  const onAggChange = (0, _react.useMemo)(() => (0, _series_change_handler.seriesChangeHandler)({
    name,
    model: series,
    onChange: onModelChange
  }, siblings), [name, onModelChange, siblings, series]);
  (0, _react.useEffect)(() => {
    var _siblings;
    // formatter is based on the last agg, i.e. active or resulting one as pipeline
    if (((_siblings = siblings[siblings.length - 1]) === null || _siblings === void 0 ? void 0 : _siblings.id) === model.id) {
      const formatterType = (0, _get_formatter_type.getFormatterType)(series.formatter);
      const isNumericMetric = (0, _check_if_numeric_metric.checkIfNumericMetric)(model, fields, indexPattern);
      const isNumberFormatter = ![_enums.DATA_FORMATTERS.DEFAULT, _enums.DATA_FORMATTERS.CUSTOM].includes(formatterType);
      if (isNumberFormatter && !isNumericMetric) {
        onModelChange({
          formatter: _enums.DATA_FORMATTERS.DEFAULT
        });
      }
      // in case of string index pattern mode, change default formatter depending on metric type
      // "number" formatter for numeric metric and "" as custom formatter for any other type
      if (formatterType === _enums.DATA_FORMATTERS.DEFAULT && !isKibanaIndexPattern) {
        onModelChange({
          formatter: isNumericMetric ? _enums.DATA_FORMATTERS.NUMBER : ''
        });
      }
    }
  }, [indexPattern, model, onModelChange, fields, series.formatter, isKibanaIndexPattern, siblings]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: props.className,
    style: style,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(Component, {
    fields: props.fields,
    disableDelete: props.disableDelete,
    model: props.model,
    onAdd: props.onAdd,
    onChange: onAggChange,
    onDelete: props.onDelete,
    panel: props.panel,
    series: props.series,
    siblings: props.siblings,
    indexPattern: indexPattern,
    uiRestrictions: props.uiRestrictions,
    dragHandleProps: props.dragHandleProps,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }));
}