"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDeleteButtons = AddDeleteButtons;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/vis_types/timeseries/public/application/components/add_delete_buttons.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function AddDeleteButtons(props) {
  const {
    testSubj
  } = props;
  const createDelete = () => {
    if (props.disableDelete) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: props.deleteTooltip,
      disableScreenReaderOutput: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": `${testSubj}DeleteBtn`,
      "aria-label": props.deleteTooltip,
      color: "danger",
      iconType: "trash",
      onClick: props.onDelete,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 11
      }
    })));
  };
  const createAdd = () => {
    if (props.disableAdd) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: props.addTooltip,
      disableScreenReaderOutput: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": `${testSubj}AddBtn`,
      "aria-label": props.addTooltip,
      iconType: "plusInCircle",
      onClick: props.onAdd,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 11
      }
    })));
  };
  const createClone = () => {
    let cloneBtn = null;
    if (props.onClone && !props.disableAdd) {
      cloneBtn = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: props.cloneTooltip,
        disableScreenReaderOutput: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": `${testSubj}CloneBtn`,
        "aria-label": props.cloneTooltip,
        iconType: "copy",
        onClick: props.onClone,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 13
        }
      })));
    }
    return cloneBtn;
  };
  const createActivatePanel = () => {
    let activatePanelBtn = null;
    if ((0, _lodash.isBoolean)(props.isPanelActive)) {
      const tooltip = props.isPanelActive ? props.deactivatePanelTooltip : props.activatePanelTooltip;
      const iconType = props.isPanelActive ? 'eye' : 'eyeClosed';
      activatePanelBtn = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: tooltip,
        disableScreenReaderOutput: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": `${testSubj}ActivatePanelBtn`,
        "aria-label": tooltip,
        iconType: iconType,
        onClick: props.togglePanelActivation,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 13
        }
      })));
    }
    return activatePanelBtn;
  };
  const deleteBtn = createDelete();
  const addBtn = createAdd();
  const cloneBtn = createClone();
  const activatePanelBtn = createActivatePanel();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: props.responsive,
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 5
    }
  }, activatePanelBtn, cloneBtn, addBtn, deleteBtn);
}
AddDeleteButtons.defaultProps = {
  testSubj: 'Add',
  activeTooltip: _i18n.i18n.translate('visTypeTimeseries.addDeleteButtons.addButtonDefaultTooltip', {
    defaultMessage: 'Add'
  }),
  addTooltip: _i18n.i18n.translate('visTypeTimeseries.addDeleteButtons.addButtonDefaultTooltip', {
    defaultMessage: 'Add'
  }),
  deleteTooltip: _i18n.i18n.translate('visTypeTimeseries.addDeleteButtons.deleteButtonDefaultTooltip', {
    defaultMessage: 'Delete'
  }),
  cloneTooltip: _i18n.i18n.translate('visTypeTimeseries.addDeleteButtons.cloneButtonDefaultTooltip', {
    defaultMessage: 'Clone'
  }),
  activatePanelTooltip: _i18n.i18n.translate('visTypeTimeseries.addDeleteButtons.reEnableTooltip', {
    defaultMessage: 'Re-enable'
  }),
  deactivatePanelTooltip: _i18n.i18n.translate('visTypeTimeseries.addDeleteButtons.temporarilyDisableTooltip', {
    defaultMessage: 'Temporarily Disable'
  })
};