"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelionVisRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public2 = require("@kbn/visualizations-plugin/public");
var _analytics = require("@kbn/analytics");
var _plugin_services = require("./helpers/plugin_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/timelion/public/timelion_vis_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LazyTimelionVisComponent = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./async_services'))).then(({
  TimelionVisComponent
}) => ({
  default: TimelionVisComponent
})));

/** @internal **/
const extractContainerType = context => {
  if (context) {
    var _recursiveGet;
    const recursiveGet = item => {
      if (item.type) {
        return item;
      } else if (item.child) {
        return recursiveGet(item.child);
      }
    };
    return (_recursiveGet = recursiveGet(context)) === null || _recursiveGet === void 0 ? void 0 : _recursiveGet.type;
  }
};
const getTimelionVisRenderer = deps => ({
  name: 'timelion_vis',
  displayName: 'Timelion visualization',
  reuseDomNode: true,
  render: async (domNode, {
    visData,
    visParams,
    syncTooltips,
    syncCursor
  }, handlers) => {
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const seriesList = visData === null || visData === void 0 ? void 0 : visData.sheet[0];
    const showNoResult = !seriesList || !seriesList.list.length;
    const onBrushEvent = rangeFilterParams => {
      handlers.event({
        name: 'applyFilter',
        data: {
          timeFieldName: '*',
          filters: [{
            query: {
              range: {
                '*': rangeFilterParams
              }
            }
          }]
        }
      });
    };
    const renderComplete = () => {
      const usageCollection = (0, _plugin_services.getUsageCollection)();
      const containerType = extractContainerType(handlers.getExecutionContext());
      if (usageCollection && containerType) {
        usageCollection.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, `render_agg_based_timelion`);
      }
      handlers.done();
    };
    (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, (0, _plugin_services.getCoreStart)(), {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_public2.VisualizationContainer, {
      renderComplete: renderComplete,
      handlers: handlers,
      showNoResult: showNoResult,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        ...deps
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 11
      }
    }, seriesList && /*#__PURE__*/_react.default.createElement(LazyTimelionVisComponent, {
      interval: visParams.interval,
      ariaLabel: visParams.ariaLabel,
      seriesList: seriesList,
      renderComplete: renderComplete,
      onBrushEvent: onBrushEvent,
      syncTooltips: syncTooltips,
      syncCursor: syncCursor,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 15
      }
    })))), domNode);
  }
});
exports.getTimelionVisRenderer = getTimelionVisRenderer;