"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toExpressionAst = void 0;
var _public = require("@kbn/expressions-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const prepareDimension = params => {
  const visdimension = (0, _public.buildExpressionFunction)('visdimension', {
    accessor: params.accessor
  });
  if (params.format) {
    visdimension.addArgument('format', params.format.id);
    visdimension.addArgument('formatParams', JSON.stringify(params.format.params));
  }
  return (0, _public.buildExpression)([visdimension]);
};
const preparePalette = palette => {
  const paletteExpressionFunction = (0, _public.buildExpressionFunction)('system_palette', {
    name: palette === null || palette === void 0 ? void 0 : palette.name
  });
  return (0, _public.buildExpression)([paletteExpressionFunction]);
};
const toExpressionAst = (vis, params) => {
  const schemas = (0, _public2.getVisSchemas)(vis, params);
  const {
    scale,
    orientation,
    minFontSize,
    maxFontSize,
    showLabel,
    palette
  } = vis.params;
  const tagcloud = (0, _public.buildExpressionFunction)('tagcloud', {
    scale,
    orientation,
    minFontSize,
    maxFontSize,
    showLabel,
    metric: prepareDimension(schemas.metric[0]),
    palette: preparePalette(palette)
  });
  if (schemas.segment) {
    tagcloud.addArgument('bucket', prepareDimension(schemas.segment[0]));
  }
  const ast = (0, _public.buildExpression)([tagcloud]);
  return ast.toAst();
};
exports.toExpressionAst = toExpressionAst;