"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableVisSplit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _table_vis_basic = require("./table_vis_basic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/table/public/components/table_vis_split.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const tableVisSplitStyles = {
  base: ({
    euiTheme
  }) => (0, _react2.css)({
    padding: euiTheme.size.s,
    marginBottom: euiTheme.size.l,
    display: 'flex',
    flexDirection: 'column',
    flex: '1 0 0',
    '> h3': {
      textAlign: 'center'
    }
  })
};
const TableVisSplit = exports.TableVisSplit = /*#__PURE__*/(0, _react.memo)(({
  fireEvent,
  tables,
  visConfig,
  uiStateProps,
  enforceMinWidth
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(tableVisSplitStyles);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tables.map(({
    table,
    title
  }) => {
    // reserve minimum size per table
    const minTableWidth = table.columns.reduce((sum, column, index) => {
      var _uiStateProps$columns, _uiStateProps$columns2;
      return sum + ((_uiStateProps$columns = (_uiStateProps$columns2 = uiStateProps.columnsWidth.find(width => width.colIndex === index)) === null || _uiStateProps$columns2 === void 0 ? void 0 : _uiStateProps$columns2.width) !== null && _uiStateProps$columns !== void 0 ? _uiStateProps$columns : 25);
    }, 0);
    return /*#__PURE__*/_react.default.createElement("div", {
      key: title,
      className: "tbvChart__split",
      css: [styles.base, enforceMinWidth ? {
        minWidth: `calc(${minTableWidth}px + 2 * ${_uiTheme.euiThemeVars.euiSizeS})`
      } : {}],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_table_vis_basic.TableVisBasic, {
      fireEvent: fireEvent,
      table: table,
      visConfig: visConfig,
      title: title,
      uiStateProps: uiStateProps,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 15
      }
    }));
  }));
});