"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGoalVisTypeDefinition = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/charts-plugin/public");
var _components = require("../editor/components");
var _to_ast = require("../to_ast");
var _types = require("../types");
var _split_tooltip = require("./split_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_types/gauge/public/vis_type/goal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getGoalVisTypeDefinition = props => ({
  name: 'goal',
  title: _i18n.i18n.translate('visTypeGauge.goal.goalTitle', {
    defaultMessage: 'Goal'
  }),
  icon: 'visGoal',
  description: _i18n.i18n.translate('visTypeGauge.goal.goalDescription', {
    defaultMessage: 'Track how a metric progresses to a goal.'
  }),
  fetchDatatable: true,
  toExpressionAst: _to_ast.toExpressionAst,
  visConfig: {
    defaults: {
      addTooltip: true,
      addLegend: false,
      isDisplayWarning: false,
      type: 'goal',
      gauge: {
        verticalSplit: false,
        autoExtend: false,
        percentageMode: true,
        gaugeType: _types.GaugeType.Arc,
        gaugeStyle: 'Full',
        backStyle: 'Full',
        orientation: 'vertical',
        useRanges: false,
        colorSchema: _public2.ColorSchemas.GreenToRed,
        gaugeColorMode: _public2.ColorMode.None,
        colorsRange: [{
          from: 0,
          to: 10000
        }],
        invertColors: false,
        labels: {
          show: true,
          color: 'black'
        },
        scale: {
          show: false,
          labels: false,
          color: 'rgba(105,112,125,0.2)',
          width: 2
        },
        type: 'meter',
        style: {
          bgFill: 'rgba(105,112,125,0.2)',
          bgColor: false,
          labelColor: false,
          subText: '',
          fontSize: 60
        }
      }
    }
  },
  editorConfig: {
    enableDataViewChange: true,
    optionsTemplate: (0, _components.getGaugeOptions)(props),
    schemas: [{
      group: _public.AggGroupNames.Metrics,
      name: 'metric',
      title: _i18n.i18n.translate('visTypeGauge.goal.metricTitle', {
        defaultMessage: 'Metric'
      }),
      min: 1,
      ...(props.showElasticChartsOptions ? {
        max: 1
      } : {}),
      aggFilter: ['!std_dev', '!geo_centroid', '!percentiles', '!percentile_ranks', '!derivative', '!serial_diff', '!moving_avg', '!cumulative_sum', '!geo_bounds', '!filtered_metric', '!single_percentile', '!single_percentile_rank'],
      defaults: [{
        schema: 'metric',
        type: 'count'
      }]
    }, {
      group: _public.AggGroupNames.Buckets,
      name: 'group',
      // TODO: Remove when split chart aggs are supported
      ...(props.showElasticChartsOptions && {
        disabled: true,
        tooltip: /*#__PURE__*/_react.default.createElement(_split_tooltip.SplitTooltip, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 106,
            columnNumber: 20
          }
        })
      }),
      title: _i18n.i18n.translate('visTypeGauge.goal.groupTitle', {
        defaultMessage: 'Split group'
      }),
      min: 0,
      max: 1,
      aggFilter: ['!geotile_grid', '!filter', '!sampler', '!diversified_sampler', '!rare_terms', '!multi_terms', '!significant_text']
    }]
  },
  requiresSearch: true,
  navigateToLens: async (vis, timefilter) => {
    const {
      convertGoalToLens
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../convert_to_lens')));
    return vis ? convertGoalToLens(vis, timefilter) : null;
  },
  getExpressionVariables: async (vis, timeFilter) => {
    const {
      convertGoalToLens
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../convert_to_lens')));
    return {
      canNavigateToLens: Boolean(vis !== null && vis !== void 0 && vis.params ? await convertGoalToLens(vis, timeFilter) : null)
    };
  }
});
exports.getGoalVisTypeDefinition = getGoalVisTypeDefinition;