"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = DefaultEditor;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _sidebar = require("./components/sidebar");
var _editor_size = require("./editor_size");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/default_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const localStorage = new _public2.Storage(window.localStorage);
const defaultEditorStyles = {
  base: euiThemeContext => (0, _react2.css)({
    flex: '1 1 auto',
    display: 'flex',
    [(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's', 'm'])]: {
      flexDirection: 'column' // change the editor direction to column
    }
  }),
  // Collapsible sidebar container
  collapsibleSidebar: euiThemeContext => (0, _react2.css)({
    flexGrow: 1,
    [(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's', 'm'])]: {
      width: '100% !important',
      // force the editor to take 100% width
      flexGrow: 0
    }
  }),
  // !importants on width and height are required to override resizable panel inline widths
  collapsibleSidebarIsClosed: euiThemeContext => (0, _react2.css)({
    minWidth: 0,
    width: `${euiThemeContext.euiTheme.size.xl} !important`,
    // Just enough room for the collapse button
    '.visEditorSidebar': {
      display: 'none',
      paddingLeft: 0
    },
    [(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's', 'm'])]: {
      height: `${euiThemeContext.euiTheme.size.xxl} !important` // Just enough room for the collapse button
    }
  }),
  // Resizer
  resizer: euiThemeContext => (0, _react2.css)({
    height: 'auto',
    [(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's', 'm'])]: {
      display: 'none' // hide the resizer button
    }
  }),
  resizerIsHidden: (0, _react2.css)({
    display: 'none'
  }),
  // Canvas area
  visWrapper: euiThemeContext => (0, _react2.css)({
    [(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's', 'm'])]: {
      width: '100% !important',
      flex: 1,
      display: 'flex',
      flexDirection: 'column'
    }
  }),
  visWrapperExpanded: (0, _react2.css)({
    width: '100% !important'
  }),
  visualization: (0, _react2.css)({
    display: 'flex',
    flex: '1 1 auto',
    // Fixes IE bug: the editor overflows a visualization on small screens
    overflow: 'hidden'
  }),
  canvas: ({
    euiTheme
  }) => (0, _react2.css)({
    backgroundColor: euiTheme.colors.emptyShade,
    display: 'flex',
    flexDirection: 'row',
    overflow: 'auto',
    flexShrink: 1,
    flexBasis: '100%',
    '.visChart': {
      position: 'relative'
    }
  })
};
function DefaultEditor({
  core,
  data,
  vis,
  uiState,
  timeRange,
  filters,
  query,
  embeddableHandler,
  eventEmitter,
  linked,
  savedSearch
}) {
  const visRef = (0, _react.useRef)(null);
  const [isCollapsed, setIsCollapsed] = (0, _react.useState)(false);
  const onClickCollapse = (0, _react.useCallback)(() => {
    setIsCollapsed(value => !value);
  }, []);

  /**
   * The empty callback is in place to prevent resetting the dragging state of the resize button.
   * The mouseLeave is triggered since a visualization is rendered through another call of "ReactDOM.render()"" in expressions,
   * using the "visRef" node reference.
   * Here is the existing React issue: https://github.com/facebook/react/issues/17064
   */
  const onEditorMouseLeave = (0, _react.useCallback)(() => {}, []);
  (0, _react.useEffect)(() => {
    if (!visRef.current) {
      return;
    }
    embeddableHandler.render(visRef.current).then(() => {
      setTimeout(async () => {
        eventEmitter.emit('embeddableRendered');
      });
    });
    return () => embeddableHandler.destroy();
  }, [embeddableHandler, eventEmitter]);
  (0, _react.useEffect)(() => {
    embeddableHandler.updateInput({
      timeRange,
      filters,
      query
    });
  }, [embeddableHandler, timeRange, filters, query]);
  const editorInitialWidth = (0, _editor_size.getInitialWidth)(vis.type.editorConfig.defaultSize);
  const styles = (0, _use_memo_css.useMemoCss)(defaultEditorStyles);
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, core, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      appName: 'vis_default_editor',
      storage: localStorage,
      data,
      ...core
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiResizableContainer, {
    className: "visEditor--default",
    onMouseLeave: onEditorMouseLeave,
    css: styles.base,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  }, (EuiResizablePanel, EuiResizableButton) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    className: "visEditor__visualization",
    initialSize: 100 - editorInitialWidth,
    minSize: "25%",
    paddingSize: "none",
    wrapperProps: {
      className: `visEditor__visualization__wrapper ${isCollapsed ? 'visEditor__visualization__wrapper-expanded' : ''}`,
      css: [styles.visWrapper, isCollapsed && styles.visWrapperExpanded]
    },
    css: styles.visualization,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "visEditor__canvas",
    ref: visRef,
    "data-shared-items-container": true,
    css: styles.canvas,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(EuiResizableButton, {
    alignIndicator: "start",
    className: `visEditor__resizer ${isCollapsed ? 'visEditor__resizer-isHidden' : ''}`,
    css: [styles.resizer, isCollapsed && styles.resizerIsHidden],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(EuiResizablePanel, {
    initialSize: editorInitialWidth,
    minSize: isCollapsed ? '0' : '350px',
    paddingSize: "none",
    wrapperProps: {
      className: `visEditor__collapsibleSidebar ${isCollapsed ? 'visEditor__collapsibleSidebar-isClosed' : ''}`,
      css: [styles.collapsibleSidebar, isCollapsed && styles.collapsibleSidebarIsClosed]
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_sidebar.DefaultEditorSideBar, {
    embeddableHandler: embeddableHandler,
    isCollapsed: isCollapsed,
    onClickCollapse: onClickCollapse,
    vis: vis,
    uiState: uiState,
    isLinkedSearch: linked,
    savedSearch: savedSearch,
    timeRange: timeRange,
    eventEmitter: eventEmitter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 17
    }
  }))))));
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;