"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultEditorSideBar = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _navbar = require("./navbar");
var _controls = require("./controls");
var _state = require("./state");
var _sidebar_title = require("./sidebar_title");
var _use_option_tabs = require("./use_option_tabs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/sidebar/sidebar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const flexParentStyle = basis => (0, _react2.css)({
  flex: `1 1 ${basis}`,
  display: 'flex',
  flexDirection: 'column',
  '> *': {
    flexShrink: 0
  }
});
const defaultEditorSideBarStyles = {
  base: euiThemeContext => (0, _react2.css)({
    height: '100%',
    paddingLeft: euiThemeContext.euiTheme.size.s,
    [(0, _eui.euiBreakpoint)(euiThemeContext, ['xs', 's', 'm'])]: {
      paddingLeft: 0
    }
  }),
  form: (0, _react2.css)({
    ...flexParentStyle('auto'),
    maxWidth: '100%'
  }),
  config: euiThemeContext => (0, _react2.css)`
      &.visEditorSidebar__config {
        padding: ${euiThemeContext.euiTheme.size.s};

        > * {
          flex-grow: 0;
        }

        ${(0, _eui.euiBreakpoint)(euiThemeContext, ['l', 'xl'])} {
          overflow: auto;
          ${flexParentStyle('1px')};
          ${(0, _eui.euiScrollBarStyles)(euiThemeContext)};
        }
      }
    `,
  configIsHidden: (0, _react2.css)({
    '&.visEditorSidebar__config-isHidden': {
      display: 'none'
    }
  }),
  collapsibleSideBarButton: ({
    euiTheme
  }) => (0, _react2.css)({
    position: 'absolute',
    right: euiTheme.size.xs,
    top: euiTheme.size.s
  })
};
function DefaultEditorSideBarComponent({
  embeddableHandler,
  isCollapsed,
  onClickCollapse,
  uiState,
  vis,
  isLinkedSearch,
  eventEmitter,
  savedSearch,
  timeRange
}) {
  const styles = (0, _use_memo_css.useMemoCss)(defaultEditorSideBarStyles);
  const [isDirty, setDirty] = (0, _react.useState)(false);
  const [state, dispatch] = (0, _state.useEditorReducer)(vis, eventEmitter);
  const {
    formState,
    setTouched,
    setValidity,
    resetValidity
  } = (0, _state.useEditorFormState)();
  const [optionTabs, setSelectedTab] = (0, _use_option_tabs.useOptionTabs)(vis);
  const responseAggs = (0, _react.useMemo)(() => state.data.aggs ? state.data.aggs.getResponseAggs() : [], [state.data.aggs]);
  const metricSchemas = (vis.type.schemas.metrics || []).map(s => s.name);
  const metricAggs = (0, _react.useMemo)(() => responseAggs.filter(agg => agg.schema && metricSchemas.includes(agg.schema)), [responseAggs, metricSchemas]);
  const hasHistogramAgg = (0, _react.useMemo)(() => responseAggs.some(agg => agg.type.name === 'histogram'), [responseAggs]);
  const setStateValidity = (0, _react.useCallback)(value => {
    setValidity('visOptions', value);
  }, [setValidity]);
  const setStateValue = (0, _react.useCallback)((paramName, value) => {
    const shouldUpdate = !(0, _lodash.isEqual)(state.params[paramName], value);
    if (shouldUpdate) {
      dispatch((0, _state.setStateParamValue)(paramName, value));
    }
  }, [dispatch, state.params]);
  const applyChanges = (0, _react.useCallback)(() => {
    if (formState.invalid || !isDirty) {
      setTouched(true);
      return;
    }
    vis.setState({
      ...vis.serialize(),
      params: state.params,
      data: {
        aggs: state.data.aggs ? state.data.aggs.aggs.map(agg => agg.serialize()) : []
      }
    });
    embeddableHandler.reload();
    eventEmitter.emit('dirtyStateChange', {
      isDirty: false
    });
    setTouched(false);
  }, [vis, state, formState.invalid, setTouched, isDirty, eventEmitter, embeddableHandler]);
  const onSubmit = (0, _react.useCallback)(event => {
    if (event.ctrlKey && event.key === _eui.keys.ENTER) {
      event.preventDefault();
      event.stopPropagation();
      applyChanges();
    }
  }, [applyChanges]);
  (0, _react.useEffect)(() => {
    const changeHandler = ({
      isDirty: dirty
    }) => {
      setDirty(dirty);
      if (!dirty) {
        resetValidity();
      }
    };
    eventEmitter.on('dirtyStateChange', changeHandler);
    return () => {
      eventEmitter.off('dirtyStateChange', changeHandler);
    };
  }, [resetValidity, eventEmitter]);

  // subscribe on external vis changes using browser history, for example press back button
  (0, _react.useEffect)(() => {
    const resetHandler = () => dispatch((0, _state.discardChanges)(vis));
    eventEmitter.on('updateEditor', resetHandler);
    return () => {
      eventEmitter.off('updateEditor', resetHandler);
    };
  }, [dispatch, vis, eventEmitter]);
  const dataTabProps = {
    dispatch,
    formIsTouched: formState.touched,
    metricAggs,
    state,
    schemas: vis.type.schemas,
    setValidity,
    setTouched,
    setStateValue
  };
  const optionTabProps = {
    aggs: state.data.aggs,
    hasHistogramAgg,
    stateParams: state.params,
    vis,
    uiState,
    setValue: setStateValue,
    setValidity: setStateValidity,
    setTouched
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "visEditorSidebar",
    direction: "column",
    justifyContent: "spaceBetween",
    gutterSize: "none",
    responsive: false,
    css: styles.base,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("form", {
    className: "visEditorSidebar__form",
    name: "visualizeEditor",
    onKeyDownCapture: onSubmit,
    css: styles.form,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 11
    }
  }, vis.type.requiresSearch && /*#__PURE__*/_react.default.createElement(_sidebar_title.SidebarTitle, {
    isLinkedSearch: isLinkedSearch,
    savedSearch: savedSearch,
    vis: vis,
    eventEmitter: eventEmitter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 15
    }
  }), optionTabs.length > 1 && /*#__PURE__*/_react.default.createElement(_navbar.DefaultEditorNavBar, {
    optionTabs: optionTabs,
    setSelectedTab: setSelectedTab,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 15
    }
  }), optionTabs.map(({
    editor: Editor,
    name,
    isSelected = false
  }) => /*#__PURE__*/_react.default.createElement("div", {
    key: name,
    className: `visEditorSidebar__config ${isSelected ? '' : 'visEditorSidebar__config-isHidden'}`,
    css: [styles.config, !isSelected && styles.configIsHidden],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(Editor, (0, _extends2.default)({
    isTabSelected: isSelected
  }, name === 'data' ? dataTabProps : optionTabProps, {
    timeRange: timeRange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 17
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_controls.DefaultEditorControls, {
    applyChanges: applyChanges,
    dispatch: dispatch,
    isDirty: isDirty,
    isTouched: formState.touched,
    isInvalid: formState.invalid,
    vis: vis,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-expanded": !isCollapsed,
    "aria-label": _i18n.i18n.translate('visDefaultEditor.sidebar.collapseButtonAriaLabel', {
      defaultMessage: 'Toggle sidebar'
    }),
    className: "visEditor__collapsibleSidebarButton",
    "data-test-subj": "collapseSideBarButton",
    color: "text",
    iconType: isCollapsed ? 'menuLeft' : 'menuRight',
    onClick: onClickCollapse,
    css: defaultEditorSideBarStyles.collapsibleSideBarButton,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 7
    }
  }));
}
const DefaultEditorSideBar = exports.DefaultEditorSideBar = /*#__PURE__*/(0, _react.memo)(DefaultEditorSideBarComponent);