"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultEditorDataTab = DefaultEditorDataTab;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _agg_group = require("../agg_group");
var _state = require("./state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/sidebar/data_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DefaultEditorDataTab({
  dispatch,
  formIsTouched,
  metricAggs,
  schemas,
  state,
  setTouched,
  setValidity,
  setStateValue,
  timeRange
}) {
  const lastParentPipelineAgg = (0, _react.useMemo)(() => (0, _lodash.findLast)(metricAggs, ({
    type
  }) => type.subtype === _public.search.aggs.parentPipelineType), [metricAggs]);
  const lastParentPipelineAggTitle = lastParentPipelineAgg && lastParentPipelineAgg.type.title;
  const addSchema = (0, _react.useCallback)(schema => dispatch((0, _state.addNewAgg)(schema)), [dispatch]);
  const onAggRemove = (0, _react.useCallback)(aggId => dispatch((0, _state.removeAgg)(aggId, schemas.all || [])), [dispatch, schemas]);
  const onReorderAggs = (0, _react.useCallback)((...props) => dispatch((0, _state.reorderAggs)(...props)), [dispatch]);
  const onAggParamValueChange = (0, _react.useCallback)((...props) => dispatch((0, _state.setAggParamValue)(...props)), [dispatch]);
  const onAggTypeChange = (0, _react.useCallback)((...props) => dispatch((0, _state.changeAggType)(...props)), [dispatch]);
  const onToggleEnableAgg = (0, _react.useCallback)((...props) => dispatch((0, _state.toggleEnabledAgg)(...props)), [dispatch]);
  const commonProps = {
    addSchema,
    formIsTouched,
    lastParentPipelineAggTitle,
    metricAggs,
    state,
    reorderAggs: onReorderAggs,
    setAggParamValue: onAggParamValueChange,
    setStateParamValue: setStateValue,
    onAggTypeChange,
    onToggleEnableAgg,
    setValidity,
    setTouched,
    removeAgg: onAggRemove
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_agg_group.DefaultEditorAggGroup, (0, _extends2.default)({
    groupName: _public.AggGroupNames.Metrics,
    schemas: schemas.metrics
  }, commonProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_agg_group.DefaultEditorAggGroup, (0, _extends2.default)({
    groupName: _public.AggGroupNames.Buckets,
    schemas: schemas.buckets,
    timeRange: timeRange
  }, commonProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  })));
}