"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultEditorControls = DefaultEditorControls;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _state = require("./state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/sidebar/controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultEditorControlsStyles = {
  base: ({
    euiTheme
  }) => (0, _react2.css)({
    borderTop: euiTheme.border.thin,
    padding: euiTheme.size.s,
    display: 'flex',
    justifyContent: 'flex-end',
    alignItems: 'center',
    '.visEditorSidebar__autoApplyButton': {
      marginLeft: euiTheme.size.m
    }
  })
};
function DefaultEditorControls({
  applyChanges,
  isDirty,
  isInvalid,
  isTouched,
  dispatch,
  vis
}) {
  const styles = (0, _use_memo_css.useMemoCss)(defaultEditorControlsStyles);
  const {
    enableAutoApply
  } = vis.type.editorConfig;
  const [autoApplyEnabled, setAutoApplyEnabled] = (0, _react.useState)(false);
  const toggleAutoApply = (0, _react.useCallback)(nextAutoApplyEnabled => setAutoApplyEnabled(nextAutoApplyEnabled), []);
  const onClickDiscard = (0, _react.useCallback)(() => dispatch((0, _state.discardChanges)(vis)), [dispatch, vis]);
  (0, _useDebounce.default)(() => {
    if (autoApplyEnabled && isDirty) {
      applyChanges();
    }
  }, 300, [isDirty, autoApplyEnabled, applyChanges]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "visEditorSidebar__controls",
    css: styles.base,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, !autoApplyEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "none",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "visualizeEditorResetButton",
    disabled: !isDirty,
    iconType: "cross",
    onClick: onClickDiscard,
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.sidebar.discardChangesButtonLabel",
    defaultMessage: "Discard",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, isInvalid && isTouched ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('visDefaultEditor.sidebar.errorButtonTooltip', {
      defaultMessage: 'Errors in the highlighted fields need to be resolved.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    iconType: "warning",
    size: "s",
    disabled: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.sidebar.updateChartButtonLabel",
    defaultMessage: "Update",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 19
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('visDefaultEditor.sidebar.updateInfoTooltip', {
      defaultMessage: 'CTRL + Enter is a shortcut for Update.'
    }),
    type: "keyboard",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "visualizeEditorRenderButton",
    disabled: !isDirty,
    fill: true,
    iconType: "play",
    onClick: applyChanges,
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.sidebar.updateChartButtonLabel",
    defaultMessage: "Update",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 21
    }
  })))))), enableAutoApply && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    title: autoApplyEnabled ? _i18n.i18n.translate('visDefaultEditor.sidebar.autoApplyChangesOnLabel', {
      defaultMessage: 'Auto apply is on'
    }) : _i18n.i18n.translate('visDefaultEditor.sidebar.autoApplyChangesOffLabel', {
      defaultMessage: 'Auto apply is off'
    }),
    content: _i18n.i18n.translate('visDefaultEditor.sidebar.autoApplyChangesTooltip', {
      defaultMessage: 'Auto updates the visualization on every change.'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    className: "visEditorSidebar__autoApplyButton",
    "data-test-subj": "visualizeEditorAutoButton",
    iconType: "refresh",
    color: autoApplyEnabled ? 'primary' : 'text',
    fill: true,
    onClick: () => toggleAutoApply(!autoApplyEnabled),
    size: "s",
    minWidth: 80,
    "aria-label": autoApplyEnabled ? _i18n.i18n.translate('visDefaultEditor.sidebar.autoApplyChangesLabelOn', {
      defaultMessage: 'Auto apply is on'
    }) : _i18n.i18n.translate('visDefaultEditor.sidebar.autoApplyChangesLabelOff', {
      defaultMessage: 'Auto apply is off'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }, autoApplyEnabled ? _i18n.i18n.translate('visDefaultEditor.sidebar.autoApplyChangesOn', {
    defaultMessage: 'On'
  }) : _i18n.i18n.translate('visDefaultEditor.sidebar.autoApplyChangesOff', {
    defaultMessage: 'Off'
  }))));
}