"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeOption = RangeOption;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/options/range.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function RangeOption({
  label,
  max,
  min,
  showInput,
  showLabels,
  showValue = true,
  step,
  paramName,
  value,
  setValue
}) {
  const [stateValue, setStateValue] = (0, _react.useState)(value);
  const [isValidState, setIsValidState] = (0, _react.useState)(true);
  const error = _i18n.i18n.translate('visDefaultEditor.options.rangeErrorMessage', {
    defaultMessage: 'Values must be on or between {min} and {max}',
    values: {
      min,
      max
    }
  });
  const onChangeHandler = (event, isValid) => {
    const {
      valueAsNumber
    } = event.target; // since we don't show ticks on EuiRange, the target will definitely be HTMLInputElement type, so we can cast it directly.

    setStateValue(valueAsNumber);
    setIsValidState(isValid);
    if (isValid) {
      setValue(paramName, valueAsNumber);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    fullWidth: true,
    isInvalid: !isValidState,
    error: error,
    display: "rowCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    compressed: true,
    fullWidth: true,
    max: max,
    min: min,
    showInput: showInput,
    showLabels: showLabels,
    showValue: showValue,
    step: step,
    value: stateValue,
    onChange: onChangeHandler,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }));
}