"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PercentageModeOption = PercentageModeOption;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/field-formats-plugin/common");
var _switch = require("./switch");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/options/percentage_mode.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function PercentageModeOption({
  'data-test-subj': dataTestSubj,
  setValue,
  percentageMode,
  formatPattern,
  disabled
}) {
  var _services$uiSettings;
  const {
    services
  } = (0, _public.useKibana)();
  const defaultPattern = (_services$uiSettings = services.uiSettings) === null || _services$uiSettings === void 0 ? void 0 : _services$uiSettings.get(_common.FORMATS_UI_SETTINGS.FORMAT_PERCENT_DEFAULT_PATTERN);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_switch.SwitchOption, {
    "data-test-subj": dataTestSubj,
    label: _i18n.i18n.translate('visDefaultEditor.options.percentageMode.percentageModeLabel', {
      defaultMessage: 'Percentage mode'
    }),
    paramName: "percentageMode",
    value: percentageMode,
    setValue: setValue,
    disabled: disabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visDefaultEditor.options.percentageMode.numeralLabel",
      defaultMessage: "Format pattern",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 11
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      href: "https://adamwdraper.github.io/Numeral-js/",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visDefaultEditor.options.percentageMode.documentationLabel",
      defaultMessage: "Numeral.js documentation",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 13
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    compressed: true,
    "data-test-subj": `${dataTestSubj}FormatPattern`,
    value: formatPattern || '',
    placeholder: defaultPattern,
    onChange: e => {
      setValue('percentageFormatPattern', e.target.value ? e.target.value : undefined);
    },
    disabled: !percentageMode,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  })));
}