"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegendSizeSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/visualizations-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/options/legend_size_settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const legendSizeOptions = [{
  value: _public.LegendSize.SMALL,
  inputDisplay: _i18n.i18n.translate('visDefaultEditor.options.legendSizeSetting.legendSizeOptions.small', {
    defaultMessage: 'Small'
  })
}, {
  value: _public.LegendSize.MEDIUM,
  inputDisplay: _i18n.i18n.translate('visDefaultEditor.options.legendSizeSetting.legendSizeOptions.medium', {
    defaultMessage: 'Medium'
  })
}, {
  value: _public.LegendSize.LARGE,
  inputDisplay: _i18n.i18n.translate('visDefaultEditor.options.legendSizeSetting.legendSizeOptions.large', {
    defaultMessage: 'Large'
  })
}, {
  value: _public.LegendSize.EXTRA_LARGE,
  inputDisplay: _i18n.i18n.translate('visDefaultEditor.options.legendSizeSetting.legendSizeOptions.extraLarge', {
    defaultMessage: 'Extra large'
  })
}];
const LegendSizeSettings = ({
  legendSize,
  onLegendSizeChange,
  isVerticalLegend,
  showAutoOption
}) => {
  (0, _react.useEffect)(() => {
    if (legendSize && !isVerticalLegend) {
      onLegendSizeChange(undefined);
    }
  }, [isVerticalLegend, legendSize, onLegendSizeChange]);
  const onLegendSizeOptionChange = (0, _react.useCallback)(size => onLegendSizeChange(size === _public.DEFAULT_LEGEND_SIZE ? undefined : size), [onLegendSizeChange]);
  const options = showAutoOption ? [{
    value: _public.LegendSize.AUTO,
    inputDisplay: _i18n.i18n.translate('visDefaultEditor.options.legendSizeSetting.legendSizeOptions.auto', {
      defaultMessage: 'Auto'
    })
  }, ...legendSizeOptions] : legendSizeOptions;
  const legendSizeSelect = /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    compressed: true,
    valueOfSelected: legendSize !== null && legendSize !== void 0 ? legendSize : _public.DEFAULT_LEGEND_SIZE,
    options: options,
    onChange: onLegendSizeOptionChange,
    disabled: !isVerticalLegend,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "visDefaultEditor.options.legendSizeSetting.label",
      defaultMessage: "Legend size",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }, isVerticalLegend ? legendSizeSelect : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('visDefaultEditor.options.legendSizeSetting.legendVertical', {
      defaultMessage: 'Requires legend to be right or left aligned'
    }),
    position: "top",
    delay: "regular",
    display: "block",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, legendSizeSelect));
};
exports.LegendSizeSettings = LegendSizeSettings;