"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowsOrColumnsControl = RowsOrColumnsControl;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/controls/rows_or_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PARAMS = {
  NAME: 'row',
  ROWS: 'visEditorSplitBy__true',
  COLUMNS: 'visEditorSplitBy__false'
};
function RowsOrColumnsControl({
  editorStateParams,
  setStateParamValue
}) {
  if (editorStateParams.row === undefined) {
    setStateParamValue(PARAMS.NAME, true);
  }
  const idSelected = `visEditorSplitBy__${editorStateParams.row}`;
  const options = [{
    id: PARAMS.ROWS,
    label: _i18n.i18n.translate('visDefaultEditor.controls.rowsLabel', {
      defaultMessage: 'Rows'
    }),
    'data-test-subj': 'visEditorSplitBy-Rows'
  }, {
    id: PARAMS.COLUMNS,
    label: _i18n.i18n.translate('visDefaultEditor.controls.columnsLabel', {
      defaultMessage: 'Columns'
    }),
    'data-test-subj': 'visEditorSplitBy-Columns'
  }];
  const onChange = (0, _react.useCallback)(optionId => setStateParamValue(PARAMS.NAME, optionId === PARAMS.ROWS), [setStateParamValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    "data-test-subj": "visEditorSplitBy",
    legend: _i18n.i18n.translate('visDefaultEditor.controls.splitByLegend', {
      defaultMessage: 'Split chart by rows or columns.'
    }),
    options: options,
    isFullWidth: true,
    idSelected: idSelected,
    onChange: onChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }));
}