"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingBucketParamEditor = MissingBucketParamEditor;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _switch = require("./switch");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/controls/missing_bucket.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function MissingBucketParamEditor(props) {
  const fieldTypeIsNotString = !_public.search.aggs.isStringType(props.agg);
  const {
    setValue
  } = props;
  (0, _react.useEffect)(() => {
    if (fieldTypeIsNotString) {
      setValue(false);
    }
  }, [fieldTypeIsNotString, setValue]);
  return /*#__PURE__*/_react.default.createElement(_switch.SwitchParamEditor, (0, _extends2.default)({}, props, {
    dataTestSubj: "missingBucketSwitch",
    displayLabel: _i18n.i18n.translate('visDefaultEditor.controls.otherBucket.showMissingValuesLabel', {
      defaultMessage: 'Show missing values'
    }),
    displayToolTip: _i18n.i18n.translate('visDefaultEditor.controls.otherBucket.showMissingValuesTooltip', {
      defaultMessage: 'Only works for fields of type "string". When enabled, include documents with missing ' + 'values in the search. If this bucket is in the top N, it appears in the chart. ' + 'If not in the top N, and you enable "Group other values in separate bucket", ' + 'Elasticsearch adds the missing values to the "other" bucket.'
    }),
    disabled: fieldTypeIsNotString,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }));
}